/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestViewPanel;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyInterestViewTask
extends ImmoToolTask<AgencyInterestViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyInterestViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyInterestViewTask.class);
    private long interestId;
    private boolean selectCreatedTab;
    private AbstractDbDriver dbDriver;
    private AgencyInterestViewPanel viewTab;

    public AgencyInterestViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public AgencyInterestViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading search mandate {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.interestId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public AgencyInterestViewTask(AbstractDbDriver abstractDbDriver, long l, AgencyInterestViewPanel agencyInterestViewPanel) {
        super(I18N.tr("Loading search mandate {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.interestId = l;
        this.selectCreatedTab = true;
        this.viewTab = agencyInterestViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AgencyInterestViewPanel doInBackground() throws Exception {
        Object object;
        DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
        if (this.viewTab == null) {
            for (AbstractMainTab abstractMainTab : ImmoToolAppUtils.getTabs(AgencyInterestViewPanel.class)) {
                AgencyInterestViewPanel agencyInterestViewPanel = (AgencyInterestViewPanel)abstractMainTab;
                if (this.interestId == 0L && agencyInterestViewPanel.getCurrentInterestId() < 1L) {
                    if (this.selectCreatedTab) {
                        ImmoToolAppUtils.selectTab((Component)((Object)agencyInterestViewPanel));
                    }
                    return null;
                }
                if (this.interestId <= 0L || agencyInterestViewPanel.getCurrentInterestId() != this.interestId) continue;
                if (this.selectCreatedTab) {
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyInterestViewPanel));
                }
                return null;
            }
        }
        if (this.interestId < 1L) {
            object = this.viewTab != null ? this.viewTab : AgencyInterestViewPanel.createTab();
        } else {
            Connection connection = null;
            try {
                connection = this.dbDriver.getConnection();
                DbAgencyInterest dbAgencyInterest = dbAgencyInterestsHandler.getInterest(connection, this.interestId);
                if (dbAgencyInterest == null) {
                    throw new Exception("Can't find interest #" + this.interestId + "!");
                }
                if (this.viewTab == null) {
                    object = AgencyInterestViewPanel.createTab(dbAgencyInterest);
                } else {
                    object = this.viewTab;
                    ((AgencyInterestViewPanel)((Object)object)).setInterest(dbAgencyInterest);
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)("Can't load interest #" + this.interestId + "!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(AgencyInterestViewPanel agencyInterestViewPanel) {
        super.succeeded((Object)agencyInterestViewPanel);
        if (agencyInterestViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyInterestViewPanel, (boolean)this.selectCreatedTab);
            }
            agencyInterestViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

