/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateTable;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryEstateBrokeringPanel
extends ContactsEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryEstateBrokeringPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryEstateBrokeringPanel.class);
    private static final String TABLE_ID = "ContactsEntryEstateBrokeringPanel.Table";
    private DbContactsEntry currentContactsEntry = null;
    private JXTitledSeparator brokeringsTitle;
    private Table brokeringsTable;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction refreshAction;

    public ContactsEntryEstateBrokeringPanel() {
        this.build();
    }

    private void build() {
        this.brokeringsTable = new Table();
        this.brokeringsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.brokeringsTitle, (Action[])new Action[]{this.refreshAction, this.showActionsAction});
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.brokeringsTable.createScrollPane(), "Center");
        this.updateLocalization();
    }

    private void doBrokeringView() {
        if (this.brokeringsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.brokeringsTable.convertRowIndexToModel(this.brokeringsTable.getSelectedRow());
        long l = this.brokeringsTable.getBrokeringIdAt(n);
        new AgencyContactsUtils.BrokeringFormAction(l).actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doLoadInBackground(Connection connection) throws Exception {
        this.brokeringsTable.setEnabled(false);
        this.brokeringsTable.clearSelection();
        this.brokeringsTable.clearRows();
        this.showActionsAction.setEnabled(false);
        ArrayList<DbAgencyBrokering> arrayList = new ArrayList<DbAgencyBrokering>();
        HashMap<Long, DbAgencyBrokering> hashMap = new HashMap<Long, DbAgencyBrokering>();
        try {
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            Map map = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
            DbAgencyBrokering[] dbAgencyBrokeringArray = dbAgencyBrokeringsHandler.getBrokeringsForContact(connection, this.currentContactsEntry.id);
            arrayList.addAll(Arrays.asList(dbAgencyBrokeringArray));
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (DbAgencyBrokering dbAgencyBrokering : dbAgencyBrokeringArray) {
                if (dbAgencyBrokering.agencyObjectId <= 0L || arrayList2.contains(dbAgencyBrokering.agencyObjectId)) continue;
                arrayList2.add(dbAgencyBrokering.agencyObjectId);
            }
            DbAgencyBrokering[] dbAgencyBrokeringArray2 = dbAgencyObjectsHandler.getObjects(connection, ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0])));
            dbAgencyObjectsHandler.loadObjectAttribs(connection, (DbObject[])dbAgencyBrokeringArray2, map);
            dbAgencyObjectsHandler.loadObjectTranslations(connection, (DbObject[])dbAgencyBrokeringArray2, map);
            for (DbAgencyBrokering dbAgencyBrokering : dbAgencyBrokeringArray2) {
                hashMap.put(((DbObject)dbAgencyBrokering).id, dbAgencyBrokering);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, hashMap){
                final /* synthetic */ List val$brokeringsList;
                final /* synthetic */ Map val$objectsMap;
                {
                    this.val$brokeringsList = list;
                    this.val$objectsMap = map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (DbAgencyBrokering dbAgencyBrokering : this.val$brokeringsList) {
                            DbAgencyObject dbAgencyObject = dbAgencyBrokering.agencyObjectId > 0L ? (DbAgencyObject)this.val$objectsMap.get(dbAgencyBrokering.agencyObjectId) : null;
                            ContactsEntryEstateBrokeringPanel.this.brokeringsTable.addRow((AbstractTable.Row)new TableRow(dbAgencyObject, dbAgencyBrokering));
                        }
                    }
                    finally {
                        ContactsEntryEstateBrokeringPanel.this.brokeringsTable.setEnabled(true);
                        ContactsEntryEstateBrokeringPanel.this.showActionsAction.setEnabled(false);
                        ContactsEntryEstateBrokeringPanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doObjectView() {
        if (this.brokeringsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.brokeringsTable.convertRowIndexToModel(this.brokeringsTable.getSelectedRow());
        long l = this.brokeringsTable.getEstateIdAt(n);
        new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
    }

    private void doRefresh() {
        try {
            this.load(this.currentContactsEntry);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't load address into panel!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.brokeringsTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new ObjectViewAction()));
        jPopupMenu.add((Action)((Object)new BrokeringViewAction()));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("brokerings"));
    }

    public boolean isLoadedInBackground() {
        return this.currentContactsEntry != null && this.currentContactsEntry.id > 0L;
    }

    public void load(DbContactsEntry dbContactsEntry) throws ImmoToolException {
        this.currentContactsEntry = dbContactsEntry;
        this.brokeringsTable.setEnabled(false);
        this.brokeringsTable.clearSelection();
        this.brokeringsTable.clearRows();
        this.showActionsAction.setEnabled(false);
        this.updateTitle();
    }

    public void save(DbContactsEntry dbContactsEntry) throws ImmoToolException {
    }

    protected void updateButtons(boolean bl) {
        this.refreshAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.brokeringsTable.getSelectedRowCount() > 0);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        Object object = StringUtils.capitalize((String)I18N.tr("brokering mandates for the address"));
        int n2 = n = this.brokeringsTable != null ? this.brokeringsTable.getRowCount() : 0;
        if (n > 0) {
            object = (String)object + " / ";
            object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.brokeringsTitle.setTitle((String)object);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        public ShowActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            ContactsEntryEstateBrokeringPanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                ContactsEntryEstateBrokeringPanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        public RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryEstateBrokeringPanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ObjectViewAction
    extends AbstractI18nAction {
        public ObjectViewAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryEstateBrokeringPanel.this.doObjectView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class BrokeringViewAction
    extends AbstractI18nAction {
        public BrokeringViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryEstateBrokeringPanel.this.doBrokeringView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show brokering mandate")));
            this.setShortDescription(I18N.tr("Show details about the brokering mandate."));
        }
    }

    private static class TableRow
    extends AgencyEstateTable.Row {
        private final DbAgencyBrokering brokering;

        public TableRow(DbAgencyObject dbAgencyObject, DbAgencyBrokering dbAgencyBrokering) {
            super(dbAgencyObject);
            this.brokering = dbAgencyBrokering;
        }

        public DbAgencyBrokering getBrokering() {
            return this.brokering;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForBrokering((TableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForBrokering(TableColumn tableColumn) {
            switch (tableColumn) {
                case BROKERING_ID: {
                    return this.brokering.id;
                }
            }
            return null;
        }
    }

    private static enum TableColumn implements AbstractTable.Column
    {
        BROKERING_ID;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                default: 
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case BROKERING_ID: {
                    return Long.class;
                }
            }
            return null;
        }

        public String getColumnName() {
            switch (this) {
                case BROKERING_ID: {
                    return StringUtils.capitalize((String)I18N.tr("mandate ID"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return false;
        }
    }

    private final class Table
    extends AgencyEstateTable<TableRow> {
        public Table() {
            super(ContactsEntryEstateBrokeringPanel.TABLE_ID);
        }

        protected void doSelect() {
            ContactsEntryEstateBrokeringPanel.this.showActionsAction.setEnabled(this.getSelectedRow() >= 0);
        }

        protected void doShowActions(int n, int n2) {
            ContactsEntryEstateBrokeringPanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            ContactsEntryEstateBrokeringPanel.this.doObjectView();
        }

        public Long getBrokeringIdAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? Long.valueOf(tableRow.getBrokering().id) : null;
        }

        protected List<AbstractTable.Column> listColumns() {
            List list = super.listColumns();
            list.addAll(Arrays.asList(TableColumn.values()));
            return list;
        }
    }
}

