/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.idx;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.ChimneyPort;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CountResidentialUnits;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.CubatureVolume;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToCollege;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToDayNursery;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToElementarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextShopping;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.utils.AbstractCsvReader;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.idx.IdxFormat;
import org.openestate.io.idx.IdxParser;
import org.openestate.io.idx.IdxRecord;
import org.openestate.io.idx.types.Media;
import org.openestate.io.idx.types.ObjectCategory;
import org.openestate.io.idx.types.ObjectType;
import org.openestate.io.idx.types.OfferType;
import org.openestate.io.idx.types.PriceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxReader
extends AbstractCsvReader<IdxParser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxReader.class);

    public IdxReader() {
        this(null);
    }

    public IdxReader(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected AgentImpl createAgent(IdxRecord idxRecord) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.setId(idxRecord.getAgencyId());
        agentImpl.setCompany(new CompanyAddressImpl());
        agentImpl.getCompany().setCompanyName(idxRecord.getAgencyName());
        agentImpl.getCompany().setCompanyNameAddition(idxRecord.getAgencyName2());
        agentImpl.getCompany().setCity(idxRecord.getAgencyCity());
        agentImpl.getCompany().setCountry(this.getCountry(idxRecord.getAgencyCountry()));
        agentImpl.getCompany().setCompanyMail(idxRecord.getAgencyEmail());
        agentImpl.getCompany().setCompanyFax(idxRecord.getAgencyFax());
        agentImpl.getCompany().setCompanyPhone(idxRecord.getAgencyPhone());
        agentImpl.getCompany().setStreet(idxRecord.getAgencyStreet());
        agentImpl.getCompany().setPostalCode(idxRecord.getAgencyZip());
        return agentImpl;
    }

    protected EstateAttachmentImpl createAttachment(Media media, EstateAttachmentType estateAttachmentType) {
        URI uRI;
        String string;
        String string2;
        block8: {
            if (media == null) {
                return null;
            }
            string2 = StringUtils.trimToNull((String)media.getFileName());
            String string3 = StringUtils.trimToNull((String)media.getUrl());
            string = StringUtils.trimToNull((String)media.getTitle());
            if (string2 == null && string3 == null) {
                return null;
            }
            uRI = null;
            try {
                uRI = string3 != null ? new URI(string3) : null;
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't build URL from: " + string3);
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                if (string2 != null) break block8;
                return null;
            }
        }
        EstateAttachmentImpl estateAttachmentImpl = this.createEmptyAttachment();
        if (string != null) {
            estateAttachmentImpl.setTitle(string.trim(), this.getOpenEstateLanguage());
        }
        if (estateAttachmentType != null) {
            estateAttachmentImpl.setType(estateAttachmentType);
        }
        if (uRI != null) {
            estateAttachmentImpl.setFile(uRI);
        } else {
            estateAttachmentImpl.setFile(string2);
        }
        estateAttachmentImpl.setMimeType(media.guessMimeType());
        return estateAttachmentImpl;
    }

    protected AgentContactImpl createContact(IdxRecord idxRecord) {
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        agentContactImpl.setStreet(idxRecord.getAgencyStreet());
        agentContactImpl.setStreet(idxRecord.getAgencyStreet());
        agentContactImpl.setPostalCode(idxRecord.getAgencyZip());
        agentContactImpl.setCity(idxRecord.getAgencyCity());
        agentContactImpl.setCountry(this.getCountry(idxRecord.getAgencyCountry()));
        agentContactImpl.setPersonFax(idxRecord.getAgencyFax());
        agentContactImpl.setPersonLastName(idxRecord.getVisitName());
        if (StringUtils.isBlank((CharSequence)agentContactImpl.getPersonLastName())) {
            agentContactImpl.setPersonLastName(idxRecord.getAgencyReference());
        }
        agentContactImpl.setPersonMail(idxRecord.getVisitEmail());
        if (StringUtils.isBlank((CharSequence)agentContactImpl.getPersonMail())) {
            agentContactImpl.setPersonMail(idxRecord.getAgencyEmail());
        }
        agentContactImpl.setPersonPhone(idxRecord.getVisitPhone());
        if (StringUtils.isBlank((CharSequence)agentContactImpl.getPersonPhone())) {
            agentContactImpl.setPersonPhone(idxRecord.getAgencyPhone());
        }
        return agentContactImpl;
    }

    protected EstateImpl createEstate(IdxRecord idxRecord) throws OpenEstateException {
        EstateAttachmentImpl estateAttachmentImpl;
        EstateAttachmentImpl estateAttachmentImpl2;
        Object object;
        EstateImpl estateImpl = this.createEmptyEstate();
        OpenEstateType openEstateType = this.getEstateType(idxRecord);
        if (openEstateType == null) {
            throw new OpenEstateException("unknown estate type");
        }
        AbstractTypeImpl abstractTypeImpl = openEstateType.createImpl();
        if (abstractTypeImpl == null) {
            throw new OpenEstateException("unsupported estate type (" + openEstateType + ")");
        }
        OpenEstateAction openEstateAction = this.getEstateAction(idxRecord, abstractTypeImpl);
        if (openEstateAction == null) {
            throw new OpenEstateException("unknown estate action");
        }
        estateImpl.setType(abstractTypeImpl, openEstateAction);
        String string = "";
        if (!StringUtils.isBlank((CharSequence)idxRecord.getRefProperty())) {
            string = string + idxRecord.getRefProperty();
        }
        if (!StringUtils.isBlank((CharSequence)idxRecord.getRefHouse())) {
            if (StringUtils.isNotBlank((CharSequence)string)) {
                string = string + "|";
            }
            string = string + idxRecord.getRefHouse();
        }
        if (!StringUtils.isBlank((CharSequence)idxRecord.getRefObject())) {
            if (StringUtils.isNotBlank((CharSequence)string)) {
                string = string + "|";
            }
            string = string + idxRecord.getRefObject();
        }
        estateImpl.setPublicId(string);
        estateImpl.getCustomValues().putCustomValue("homegate.id", (Object)idxRecord.getAdvertisementId(), 5);
        estateImpl.getCustomValues().putCustomValue("homegate.url", (Object)idxRecord.getOwnObjectUrl(), 5);
        estateImpl.getAddress().setStreet(idxRecord.getObjectStreet());
        estateImpl.getAddress().setPostalCode(idxRecord.getObjectZip());
        estateImpl.getAddress().setCity(idxRecord.getObjectCity());
        estateImpl.getAddress().setRegion(idxRecord.getObjectState());
        estateImpl.getAddress().setCountry(this.getCountry(idxRecord.getObjectCountry()));
        AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)idxRecord.getAvailableFrom());
        estateImpl.setTitle(idxRecord.getObjectTitle());
        if (StringUtils.isBlank((CharSequence)estateImpl.getTitle(this.getOpenEstateLanguage()))) {
            estateImpl.setTitle("Immobilienangebot", this.getOpenEstateLanguage());
        }
        DetailledDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)idxRecord.getObjectDescription());
        estateImpl.setCurrency(idxRecord.getCurrency());
        if (estateImpl.getCurrency() == null) {
            estateImpl.setCurrency(Currency.getInstance("EUR"));
        }
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            object = idxRecord.getPriceUnit();
            if (PriceUnit.SELLM2.equals(object)) {
                PurchasePricePerArea.put((EstateImpl)estateImpl, (Number)idxRecord.getSellingPrice());
            } else {
                PurchasePrice.put((EstateImpl)estateImpl, (Number)idxRecord.getSellingPrice());
            }
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            Lease.put((EstateImpl)estateImpl, (Number)idxRecord.getSellingPrice());
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)idxRecord.getSellingPrice());
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)idxRecord.getRentNet());
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            RentFlatRate.put((EstateImpl)estateImpl, (Number)idxRecord.getSellingPrice());
            object = idxRecord.getPriceUnit();
            if (PriceUnit.DAILY.equals(object)) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.DAY);
            } else if (PriceUnit.WEEKLY.equals(object)) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.WEEK);
            } else if (PriceUnit.MONTHLY.equals(object)) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.MONTH);
            } else if (PriceUnit.YEARLY.equals(object)) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.YEAR);
            }
        }
        ServiceCharges.put((EstateImpl)estateImpl, (Number)idxRecord.getRentExtra());
        object = idxRecord.getFloor();
        if (object != null) {
            Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)((Integer)object).toString());
        }
        CountFloors.put((EstateImpl)estateImpl, (Number)idxRecord.getNumberOfFloors());
        CountRooms.put((EstateImpl)estateImpl, (Number)idxRecord.getNumberOfRooms());
        CountResidentialUnits.put((EstateImpl)estateImpl, (Number)idxRecord.getNumberOfApartments());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)idxRecord.getSurfaceLiving(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)idxRecord.getSurfaceProperty(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)idxRecord.getSurfaceUsable(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CubatureVolume.put((EstateImpl)estateImpl, (Number)idxRecord.getVolume(), (VolumeValue.Unit)VolumeValue.Unit.CUM);
        BuildYear.put((EstateImpl)estateImpl, (Number)idxRecord.getYearBuilt());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)idxRecord.getYearRenovated());
        if (ObjectType.APPT_FURNISHED_FLAT.equals((Object)idxRecord.getObjectType())) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.YES);
        }
        WarehouseHeight.put((EstateImpl)estateImpl, (Number)idxRecord.getHallHeight(), (LengthValue.Unit)LengthValue.Unit.M);
        FloorLoading.put((EstateImpl)estateImpl, (Number)idxRecord.getMaximalFloorLoading());
        CraneLiftingCapacity.put((EstateImpl)estateImpl, (Number)idxRecord.getCarryingCapacityCrane());
        FreightElevatorCapacity.put((EstateImpl)estateImpl, (Number)idxRecord.getCarryingCapacityElevator());
        if (idxRecord.isBuildingLandConnected()) {
            Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.COMPLETELY);
        }
        ChimneyPort.put((EstateImpl)estateImpl, (Boolean)idxRecord.isFireplace());
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)idxRecord.isBalcony());
        Ramp.put((EstateImpl)estateImpl, (Boolean)idxRecord.isRamp());
        LiftingPlatform.put((EstateImpl)estateImpl, (Boolean)idxRecord.isLiftingPlatform());
        SwimmingPool.put((EstateImpl)estateImpl, (Boolean)idxRecord.isSwimmingpool());
        Pets.put((EstateImpl)estateImpl, (Pets.Option)(idxRecord.isAnimalAllowed() ? Pets.Option.YES : Pets.Option.NO));
        if (idxRecord.isCableTv()) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.CABLE_TV);
        }
        if (idxRecord.isElevator()) {
            if (abstractTypeImpl.hasAttrib(OpenEstateAttrib.FEATURES_LIFT)) {
                Lift.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            } else if (abstractTypeImpl.hasAttrib(OpenEstateAttrib.FEATURES_FREIGHT_ELEVATOR)) {
                FreightElevator.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            }
        }
        if (idxRecord.isParking()) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GENERAL);
        }
        if (idxRecord.isGarage()) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GARAGE);
        }
        if (idxRecord.isWheelchairAccessible()) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        if (idxRecord.isRestrooms()) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if (idxRecord.isNewBuilding()) {
            Age.put((EstateImpl)estateImpl, (Age.Option)Age.Option.NEW_BUILDING);
        } else if (idxRecord.isOldBuilding()) {
            Age.put((EstateImpl)estateImpl, (Age.Option)Age.Option.OLD_BUILDING);
        }
        DistanceToDayNursery.put((EstateImpl)estateImpl, (Number)idxRecord.getDistanceKindergarten(), (LengthValue.Unit)LengthValue.Unit.M);
        DistanceToMotorway.put((EstateImpl)estateImpl, (Number)idxRecord.getDistanceMotorway(), (LengthValue.Unit)LengthValue.Unit.M);
        DistanceToBusStation.put((EstateImpl)estateImpl, (Number)idxRecord.getDistancePublicTransport(), (LengthValue.Unit)LengthValue.Unit.M);
        DistanceToElementarySchool.put((EstateImpl)estateImpl, (Number)idxRecord.getDistanceSchool1(), (LengthValue.Unit)LengthValue.Unit.M);
        DistanceToCollege.put((EstateImpl)estateImpl, (Number)idxRecord.getDistanceSchool2(), (LengthValue.Unit)LengthValue.Unit.M);
        DistanceToNextShopping.put((EstateImpl)estateImpl, (Number)idxRecord.getDistanceShop(), (LengthValue.Unit)LengthValue.Unit.M);
        EstateAttachmentImpl estateAttachmentImpl3 = idxRecord.getPictures();
        if (!ArrayUtils.isEmpty((Object[])estateAttachmentImpl3)) {
            estateAttachmentImpl2 = estateAttachmentImpl3;
            int n = ((Object[])estateAttachmentImpl2).length;
            for (int i = 0; i < n; ++i) {
                EstateAttachmentImpl estateAttachmentImpl4 = estateAttachmentImpl2[i];
                EstateAttachmentImpl estateAttachmentImpl5 = this.createAttachment((Media)estateAttachmentImpl4, EstateAttachmentType.IMAGE);
                if (estateAttachmentImpl5 == null) continue;
                estateImpl.getAttachments().add(estateAttachmentImpl5);
            }
        }
        if ((estateAttachmentImpl2 = this.createAttachment(idxRecord.getMovie(), null)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl2);
        }
        if ((estateAttachmentImpl = this.createAttachment(idxRecord.getDocument(), null)) != null) {
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        return estateImpl;
    }

    protected IdxParser createParser(InputStream inputStream) throws IOException {
        return IdxParser.create((InputStream)inputStream);
    }

    protected IdxParser createParser(Reader reader) throws IOException {
        return IdxParser.create((Reader)reader);
    }

    protected String getCountry(String string) {
        return IdxFormat.getCountryCode((String)string);
    }

    protected OpenEstateAction getEstateAction(IdxRecord idxRecord, AbstractTypeImpl abstractTypeImpl) throws OpenEstateException {
        OfferType offerType = idxRecord.getOfferType();
        if (OfferType.SALE.equals((Object)offerType)) {
            return OpenEstateAction.PURCHASE;
        }
        if (OfferType.RENT.equals((Object)offerType)) {
            if (abstractTypeImpl.hasAction(OpenEstateAction.RENT)) {
                return OpenEstateAction.RENT;
            }
            if (abstractTypeImpl.hasAction(OpenEstateAction.LEASE)) {
                return OpenEstateAction.LEASE;
            }
            if (abstractTypeImpl.hasAction(OpenEstateAction.EMPHYTEUSIS)) {
                return OpenEstateAction.EMPHYTEUSIS;
            }
            if (abstractTypeImpl.hasAction(OpenEstateAction.SHORT_TERM_RENT)) {
                return OpenEstateAction.SHORT_TERM_RENT;
            }
        } else {
            throw new OpenEstateException("unknown offer type: " + offerType);
        }
        return null;
    }

    protected OpenEstateType getEstateType(IdxRecord idxRecord) throws OpenEstateException {
        ObjectCategory objectCategory = idxRecord.getObjectCategory();
        ObjectType objectType = idxRecord.getObjectType();
        if (ObjectCategory.AGRI.equals((Object)objectCategory)) {
            if (ObjectType.AGRI_ALPINE.equals((Object)objectType)) {
                return OpenEstateType.FARM;
            }
            if (ObjectType.AGRI_FARM.equals((Object)objectType)) {
                return OpenEstateType.FARM;
            }
            if (ObjectType.AGRI_GENERAL.equals((Object)objectType)) {
                return OpenEstateType.GENERAL_AGRICULTURE;
            }
            return OpenEstateType.GENERAL_AGRICULTURE;
        }
        if (ObjectCategory.APPT.equals((Object)objectCategory)) {
            if (idxRecord.isFlatSharingCommunity()) {
                return OpenEstateType.APARTMENT_SHARE;
            }
            if (idxRecord.isRaisedGroundFloor()) {
                return OpenEstateType.MEZZANINE;
            }
            if (ObjectType.APPT_ATTIC.equals((Object)objectType)) {
                return OpenEstateType.RESIDENCE;
            }
            if (ObjectType.APPT_ATTIC_FLAT.equals((Object)objectType)) {
                return OpenEstateType.ATTIC_APARTMENT;
            }
            if (ObjectType.APPT_BACHERLOR_FLAT.equals((Object)objectType)) {
                return OpenEstateType.RESIDENCE;
            }
            if (ObjectType.APPT_DUPLEX.equals((Object)objectType)) {
                return OpenEstateType.MAISONETTE;
            }
            if (ObjectType.APPT_GENERAL.equals((Object)objectType)) {
                return OpenEstateType.RESIDENCE;
            }
            if (ObjectType.APPT_LOFT.equals((Object)objectType)) {
                return OpenEstateType.LOFT;
            }
            if (ObjectType.APPT_ROOF_FLAT.equals((Object)objectType)) {
                return OpenEstateType.ATTIC_APARTMENT;
            }
            if (ObjectType.APPT_SINGLE_ROOM.equals((Object)objectType)) {
                return OpenEstateType.ROOM;
            }
            if (ObjectType.APPT_STUDIO.equals((Object)objectType)) {
                return OpenEstateType.STUDIO;
            }
            if (ObjectType.APPT_TERRACE_FLAT.equals((Object)objectType)) {
                return OpenEstateType.TERRACE_APARTMENT;
            }
            if (ObjectType.APPT_FURNISHED_FLAT.equals((Object)objectType)) {
                return OpenEstateType.RESIDENCE;
            }
            return OpenEstateType.RESIDENCE;
        }
        if (ObjectCategory.GARDEN.equals((Object)objectCategory)) {
            if (ObjectType.GARDEN_GENERAL.equals((Object)objectType)) {
                return OpenEstateType.GARDEN_GROUND;
            }
            return OpenEstateType.GARDEN_GROUND;
        }
        if (ObjectCategory.GASTRO.equals((Object)objectCategory)) {
            if (ObjectType.GASTRO_BAR.equals((Object)objectType)) {
                return OpenEstateType.RESTAURANT_BAR;
            }
            if (ObjectType.GASTRO_CAFE.equals((Object)objectType)) {
                return OpenEstateType.BISTRO_CAFE;
            }
            if (ObjectType.GASTRO_CAMPING.equals((Object)objectType)) {
                return OpenEstateType.LEISURE_FACILITY;
            }
            if (ObjectType.GASTRO_CASINO.equals((Object)objectType)) {
                return OpenEstateType.LEISURE_FACILITY;
            }
            if (ObjectType.GASTRO_CINEMA_THEATRE.equals((Object)objectType)) {
                return OpenEstateType.LEISURE_FACILITY;
            }
            if (ObjectType.GASTRO_CLUB_DISCO.equals((Object)objectType)) {
                return OpenEstateType.DISCOTHEQUE;
            }
            if (ObjectType.GASTRO_GOLF.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.GASTRO_HOTEL.equals((Object)objectType)) {
                return OpenEstateType.HOTEL;
            }
            if (ObjectType.GASTRO_INDOOR_SWIMMING.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.GASTRO_INDOOR_TENNIS.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.GASTRO_MOTEL.equals((Object)objectType)) {
                return OpenEstateType.HOSTEL;
            }
            if (ObjectType.GASTRO_OUTDOOR_SWIMMING.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.GASTRO_OUTDOOR_TENNIS.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.GASTRO_PUB.equals((Object)objectType)) {
                return OpenEstateType.RESTAURANT_BAR;
            }
            if (ObjectType.GASTRO_RESTAURANT.equals((Object)objectType)) {
                return OpenEstateType.RESTAURANT;
            }
            if (ObjectType.GASTRO_SPORTS_HALL.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.GASTRO_SQUASH_BADMINTON.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            return OpenEstateType.GASTRONOMY;
        }
        if (ObjectCategory.HOUSE.equals((Object)objectCategory)) {
            if (idxRecord.isCornerHouse()) {
                return OpenEstateType.TERRACED_HOUSE_CORNERSIDE;
            }
            if (idxRecord.isMiddleHouse()) {
                return OpenEstateType.TERRACED_HOUSE_MIDDLE;
            }
            if (ObjectType.HOUSE_CASTLE.equals((Object)objectType)) {
                return OpenEstateType.CASTLE;
            }
            if (ObjectType.HOUSE_CAVE_HOUSE.equals((Object)objectType)) {
                return OpenEstateType.HOUSE;
            }
            if (ObjectType.HOUSE_CHALET.equals((Object)objectType)) {
                return OpenEstateType.CHALET;
            }
            if (ObjectType.HOUSE_DUPLEX.equals((Object)objectType)) {
                return OpenEstateType.DUPLEX_HOUSE;
            }
            if (ObjectType.HOUSE_FARM.equals((Object)objectType)) {
                return OpenEstateType.FARMHOUSE;
            }
            if (ObjectType.HOUSE_GRANNY_FLAT.equals((Object)objectType)) {
                return OpenEstateType.RESIDENCE;
            }
            if (ObjectType.HOUSE_MULTI_FAMILY.equals((Object)objectType)) {
                return OpenEstateType.MULTI_FAMILY_HOUSE;
            }
            if (ObjectType.HOUSE_ROW.equals((Object)objectType)) {
                return OpenEstateType.TERRACED_HOUSE;
            }
            if (ObjectType.HOUSE_RUSTICO.equals((Object)objectType)) {
                return OpenEstateType.RUSTICO;
            }
            if (ObjectType.HOUSE_SINGLE_FAMILY.equals((Object)objectType)) {
                return OpenEstateType.SINGLE_FAMILY_HOUSE;
            }
            if (ObjectType.HOUSE_TERRACE.equals((Object)objectType)) {
                return OpenEstateType.HOUSE;
            }
            if (ObjectType.HOUSE_VILLA.equals((Object)objectType)) {
                return OpenEstateType.VILLA;
            }
            return OpenEstateType.HOUSE;
        }
        if (ObjectCategory.INDUS.equals((Object)objectCategory)) {
            if (ObjectType.INDUS_ADVERTISING.equals((Object)objectType)) {
                return OpenEstateType.EXHIBITION_AREA;
            }
            if (ObjectType.INDUS_ARCADE.equals((Object)objectType)) {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            if (ObjectType.INDUS_ATELIER.equals((Object)objectType)) {
                return OpenEstateType.ATELIER;
            }
            if (ObjectType.INDUS_BAKERY.equals((Object)objectType)) {
                return OpenEstateType.PRODUCTION;
            }
            if (ObjectType.INDUS_BUTCHER.equals((Object)objectType)) {
                return OpenEstateType.PRODUCTION;
            }
            if (ObjectType.INDUS_CARPENTRY.equals((Object)objectType)) {
                return OpenEstateType.PRODUCTION;
            }
            if (ObjectType.INDUS_CHEESE_FACTORY.equals((Object)objectType)) {
                return OpenEstateType.PRODUCTION;
            }
            if (ObjectType.INDUS_COMMERCIAL.equals((Object)objectType)) {
                return OpenEstateType.MANUFACTORING_AREA;
            }
            if (ObjectType.INDUS_DEPARTMENT_STORE.equals((Object)objectType)) {
                return OpenEstateType.COMMERCIAL_BUILDING;
            }
            if (ObjectType.INDUS_DISPLAY_WINDOW.equals((Object)objectType)) {
                return OpenEstateType.EXHIBITION_AREA;
            }
            if (ObjectType.INDUS_FACTORY.equals((Object)objectType)) {
                return OpenEstateType.MANUFACTORING_AREA;
            }
            if (ObjectType.INDUS_FUEL_STATION.equals((Object)objectType)) {
                return OpenEstateType.PETROL_STATION;
            }
            if (ObjectType.INDUS_GARAGE.equals((Object)objectType)) {
                return OpenEstateType.GARAGE;
            }
            if (ObjectType.INDUS_GARDENING.equals((Object)objectType)) {
                return OpenEstateType.GARDENING;
            }
            if (ObjectType.INDUS_HAIRDRESSER.equals((Object)objectType)) {
                return OpenEstateType.PRODUCTION;
            }
            if (ObjectType.INDUS_HOME.equals((Object)objectType)) {
                return OpenEstateType.HOUSING_COMPLEX;
            }
            if (ObjectType.INDUS_HOSPITAL.equals((Object)objectType)) {
                return OpenEstateType.HOSPITAL_CLINIC;
            }
            if (ObjectType.INDUS_INDUSTRY.equals((Object)objectType)) {
                return OpenEstateType.INDUSTRIAL_FACILITY;
            }
            if (ObjectType.INDUS_KIOSK.equals((Object)objectType)) {
                return OpenEstateType.KIOSK;
            }
            if (ObjectType.INDUS_LABORATORY.equals((Object)objectType)) {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            if (ObjectType.INDUS_LIBRARY.equals((Object)objectType)) {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            if (ObjectType.INDUS_LIVING_COMMERCIAL.equals((Object)objectType)) {
                return OpenEstateType.HOUSING_COMPLEX;
            }
            if (ObjectType.INDUS_MINI_GOLF.equals((Object)objectType)) {
                return OpenEstateType.SPORTS_FACILITY;
            }
            if (ObjectType.INDUS_NURSING.equals((Object)objectType)) {
                return OpenEstateType.HOUSING_COMPLEX;
            }
            if (ObjectType.INDUS_OFFICE.equals((Object)objectType)) {
                return OpenEstateType.OFFICE;
            }
            if (ObjectType.INDUS_OLD_AGE_HOME.equals((Object)objectType)) {
                return OpenEstateType.SENIOR_HOUSING_COMPLEX;
            }
            if (ObjectType.INDUS_PARKING_GARAGE.equals((Object)objectType)) {
                return OpenEstateType.CAR_PARK;
            }
            if (ObjectType.INDUS_PARKING_SURFACE.equals((Object)objectType)) {
                return OpenEstateType.PARKING_SPACE;
            }
            if (ObjectType.INDUS_PARTY_ROOM.equals((Object)objectType)) {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            if (ObjectType.INDUS_RIDING_HALL.equals((Object)objectType)) {
                return OpenEstateType.RIDING_ESTATE;
            }
            if (ObjectType.INDUS_SANATORIUM.equals((Object)objectType)) {
                return OpenEstateType.SANATORIUM;
            }
            if (ObjectType.INDUS_SAUNA.equals((Object)objectType)) {
                return OpenEstateType.LEISURE_SPORTS_FACILITY;
            }
            if (ObjectType.INDUS_SHOP.equals((Object)objectType)) {
                return OpenEstateType.SHOP;
            }
            if (ObjectType.INDUS_SHOPPING_CENTRE.equals((Object)objectType)) {
                return OpenEstateType.SHOPPING_CENTER;
            }
            if (ObjectType.INDUS_SOLARIUM.equals((Object)objectType)) {
                return OpenEstateType.TANNING_SALON;
            }
            if (ObjectType.INDUS_STORAGE.equals((Object)objectType)) {
                return OpenEstateType.WAREHOUSE;
            }
            if (ObjectType.INDUS_SURGERY.equals((Object)objectType)) {
                return OpenEstateType.SURGERY;
            }
            if (ObjectType.INDUS_WORKSHOP.equals((Object)objectType)) {
                return OpenEstateType.WORKSHOP;
            }
            return OpenEstateType.GENERAL_COMMERCIAL;
        }
        if (ObjectCategory.PARK.equals((Object)objectCategory)) {
            if (ObjectType.PARK_BIKE_INDOOR.equals((Object)objectType)) {
                return OpenEstateType.PARKING_SPACE;
            }
            if (ObjectType.PARK_BIKE_OUTDOOR.equals((Object)objectType)) {
                return OpenEstateType.OUTDOOR_CAR_PARKING_SPACE;
            }
            if (ObjectType.PARK_BOAT_DRY_DOCK.equals((Object)objectType)) {
                return OpenEstateType.PARKING_SPACE;
            }
            if (ObjectType.PARK_BOAT_LANDING_STAGE.equals((Object)objectType)) {
                return OpenEstateType.BERTH;
            }
            if (ObjectType.PARK_BOAT_MOORING.equals((Object)objectType)) {
                return OpenEstateType.PARKING_SPACE;
            }
            if (ObjectType.PARK_COVERED_SLOT.equals((Object)objectType)) {
                return OpenEstateType.CARPORT;
            }
            if (ObjectType.PARK_DOUBLE_GARAGE.equals((Object)objectType)) {
                return OpenEstateType.DOUBLE_GARAGE;
            }
            if (ObjectType.PARK_HORSE_BOX.equals((Object)objectType)) {
                return OpenEstateType.PARKING_SPACE;
            }
            if (ObjectType.PARK_OPEN_SLOT.equals((Object)objectType)) {
                return OpenEstateType.PARKING_SPACE;
            }
            if (ObjectType.PARK_SINGLE_GARAGE.equals((Object)objectType)) {
                return OpenEstateType.GARAGE;
            }
            if (ObjectType.PARK_UNDERGROUND_SLOT.equals((Object)objectType)) {
                return OpenEstateType.UNDERGROUND_CAR_PARK_UNIT;
            }
            return OpenEstateType.GENERAL_PARKING;
        }
        if (ObjectCategory.PROP.equals((Object)objectCategory)) {
            if (ObjectType.PROP_AGRICULTURAL.equals((Object)objectType)) {
                return OpenEstateType.AGRICULTURAL_FORESTRY_GROUND;
            }
            if (ObjectType.PROP_BUILDING.equals((Object)objectType)) {
                return OpenEstateType.GENERAL_PIECE_OF_LAND;
            }
            if (ObjectType.PROP_COMMERCIAL.equals((Object)objectType)) {
                return OpenEstateType.COMMERCIAL_GROUND;
            }
            if (ObjectType.PROP_INDUSTRIAL.equals((Object)objectType)) {
                return OpenEstateType.INDUSTRIAL_GROUND;
            }
            return OpenEstateType.GENERAL_PIECE_OF_LAND;
        }
        throw new OpenEstateException("unknown category: " + objectCategory);
    }

    protected void initRecord(IdxRecord idxRecord) {
    }

    protected AgencyImpl readAgency(IdxParser idxParser) {
        this.getErrorMap().clear();
        AgencyImpl agencyImpl = this.createEmptyAgency();
        boolean bl = true;
        while (idxParser.hasNext()) {
            IdxRecord idxRecord = (IdxRecord)idxParser.next();
            this.initRecord(idxRecord);
            try {
                if (bl) {
                    bl = false;
                    agencyImpl.setAgent(this.createAgent(idxRecord));
                }
                AgentContactImpl agentContactImpl = this.createContact(idxRecord);
                agentContactImpl.setId("NewContact." + (agencyImpl.getContacts().size() + 1));
                EstateImpl estateImpl = this.createEstate(idxRecord);
                estateImpl.setId("NewEstate." + (agencyImpl.getEstates().size() + 1));
                estateImpl.setContactId(agentContactImpl.getId());
                agencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
                agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
            }
            catch (Exception exception) {
                LOGGER.error("Can't read line " + idxParser.getCurrentLineNumber() + "!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return agencyImpl;
    }

    protected TransferImpl readTransfer(IdxParser idxParser) {
        this.getErrorMap().clear();
        TransferImpl transferImpl = this.createEmptyTransfer();
        TransferAgencyImpl transferAgencyImpl = null;
        while (idxParser.hasNext()) {
            IdxRecord idxRecord = (IdxRecord)idxParser.next();
            this.initRecord(idxRecord);
            try {
                if (transferAgencyImpl == null || !StringUtils.trimToEmpty((String)transferAgencyImpl.getAgent().getId()).equalsIgnoreCase(StringUtils.trimToEmpty((String)idxRecord.getAgencyId()))) {
                    transferAgencyImpl = this.createEmptyTransferAgency();
                    transferAgencyImpl.setAgent(this.createAgent(idxRecord));
                    transferImpl.getAgencies().add(transferAgencyImpl);
                }
                AgentContactImpl agentContactImpl = this.createContact(idxRecord);
                agentContactImpl.setId("NewContact." + (transferAgencyImpl.getContacts().size() + 1));
                EstateImpl estateImpl = this.createEstate(idxRecord);
                estateImpl.setId("NewEstate." + (transferAgencyImpl.getEstatesToSave().size() + 1));
                estateImpl.setContactId(agentContactImpl.getId());
                transferAgencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            catch (Exception exception) {
                LOGGER.error("Can't read line " + idxParser.getCurrentLineNumber() + "!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return transferImpl;
    }
}

