/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringTable;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.EntryTableExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyBrokeringTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyBrokeringTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyBrokeringTablePanel.class);
    private static final String TABLE_ID = "AgencyBrokeringTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_PERSON = 1;
    private static final int FILTER_ADDRESS = 2;
    private static final int FILTER_STATUS = 3;
    private static final int COUNT_FILTERS = 4;
    private final List<Long> unknownAddressIds = new ArrayList<Long>();
    private List<String> filterValues;
    private JLabel filterIdLabel;
    private JFormattedTextField filterIdField;
    private JLabel filterPersonLabel;
    private JTextField filterPersonField;
    private JLabel filterAddressLabel;
    private JTextField filterAddressField;
    private JLabel filterStatusLabel;
    private JComboBox<DbAgencyObject.Status> filterStatusField;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private AgencyBrokeringTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new BrokeringAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.filterValues.add(null);
        }
        this.filterIdLabel = new JLabel();
        this.filterIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.filterIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!AgencyBrokeringTablePanel.this.filterIdField.isEnabled()) {
                    return;
                }
                try {
                    AgencyBrokeringTablePanel.this.filterIdField.commitEdit();
                }
                catch (Exception exception) {
                    AgencyBrokeringTablePanel.this.filterIdField.setValue(null);
                }
                String string2 = string = AgencyBrokeringTablePanel.this.filterIdField.isEditValid() ? AgencyBrokeringTablePanel.this.filterIdField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && AgencyBrokeringTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase(AgencyBrokeringTablePanel.this.filterValues.get(0))) {
                    return;
                }
                AgencyBrokeringTablePanel.this.filterValues.set(0, string);
                AgencyBrokeringTablePanel.this.updateFilters(true);
            }
        });
        this.filterPersonLabel = new JLabel();
        this.filterPersonField = new JTextField();
        this.filterPersonField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyBrokeringTablePanel.this.filterPersonField.isEnabled()) {
                    return;
                }
                String string = AgencyBrokeringTablePanel.this.filterPersonField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyBrokeringTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase(AgencyBrokeringTablePanel.this.filterValues.get(1))) {
                    return;
                }
                AgencyBrokeringTablePanel.this.filterValues.set(1, string);
                AgencyBrokeringTablePanel.this.updateFilters(true);
            }
        });
        this.filterAddressLabel = new JLabel();
        this.filterAddressField = new JTextField();
        this.filterAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyBrokeringTablePanel.this.filterAddressField.isEnabled()) {
                    return;
                }
                String string = AgencyBrokeringTablePanel.this.filterAddressField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyBrokeringTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (string.equalsIgnoreCase(AgencyBrokeringTablePanel.this.filterValues.get(2))) {
                    return;
                }
                AgencyBrokeringTablePanel.this.filterValues.set(2, string);
                AgencyBrokeringTablePanel.this.updateFilters(true);
            }
        });
        this.filterStatusLabel = new JLabel();
        this.filterStatusField = new JComboBox();
        this.filterStatusField.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.filterStatusField.addItem(null);
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            this.filterStatusField.addItem(status);
        }
        this.filterStatusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyBrokeringTablePanel.this.filterStatusField.isEnabled()) {
                    return;
                }
                DbAgencyObject.Status status = (DbAgencyObject.Status)AgencyBrokeringTablePanel.this.filterStatusField.getSelectedItem();
                if (status == null && AgencyBrokeringTablePanel.this.filterValues.get(3) == null) {
                    return;
                }
                if (status != null && status.name().equalsIgnoreCase(AgencyBrokeringTablePanel.this.filterValues.get(3))) {
                    return;
                }
                AgencyBrokeringTablePanel.this.filterValues.set(3, status != null ? status.name() : null);
                AgencyBrokeringTablePanel.this.updateFilters(true);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref");
        defaultFormBuilder.add((Component)this.filterIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.filterIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterPersonLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterPersonField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterAddressLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterAddressField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterStatusLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.filterStatusField).xy(15, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    public static AgencyBrokeringTablePanel createTab() {
        return new AgencyBrokeringTablePanel();
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyBrokeringTable.Row>(){

            public boolean include(AgencyBrokeringTable.Row row) {
                Number number = AgencyBrokeringTablePanel.this.filterIdField.isEditValid() ? (Number)((Number)AgencyBrokeringTablePanel.this.filterIdField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getEntry().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyBrokeringTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyBrokeringTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)AgencyBrokeringTablePanel.this.filterAddressField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 6.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPostalCode())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCity())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getDistrict())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getRegion())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.writeStreet())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyBrokeringTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyBrokeringTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)AgencyBrokeringTablePanel.this.filterPersonField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 7.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPersonLastName())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getPersonFirstName())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyBrokeringTable.Row>(){

            public boolean include(AgencyBrokeringTable.Row row) {
                DbAgencyObject.Status status = (DbAgencyObject.Status)AgencyBrokeringTablePanel.this.filterStatusField.getSelectedItem();
                return status == null || status.equals((Object)row.getAgencyObject().status);
            }
        });
        return this.table;
    }

    private void doBrokeringRemove() {
        if (!AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_REMOVE)) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])nArray)) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : nArray) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getBrokeringIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove the selected brokering mandates?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new BrokeringRemoveTask(lArray));
    }

    private void doBrokeringView() {
        if (!AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int n2 = n < 10 ? n : 10;
        int n3 = 0;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        for (int n4 : this.table.getSelectedRows()) {
            int n5 = this.table.convertRowIndexToModel(n4);
            long l = this.table.getBrokeringIdAt(n5);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyBrokeringViewTask(immoToolProject.getDbDriver(), l, n2 == 1));
            if (++n3 >= 10) break;
        }
    }

    protected void doHelp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.unknownAddressIds.clear();
        this.table.setEnabled(false);
        this.table.clearSelection();
        this.table.clearRows();
        this.updateFilters(false);
        ArrayList<DbAgencyBrokering> arrayList = new ArrayList<DbAgencyBrokering>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        HashMap<Long, DbContactsEntry> hashMap2 = new HashMap<Long, DbContactsEntry>();
        HashMap<Long, DbAgencyObject> hashMap3 = new HashMap<Long, DbAgencyObject>();
        try {
            void var14_28;
            void var13_21;
            void var13_19;
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            DbAgencyBrokering[] dbAgencyBrokeringArray = dbAgencyBrokeringsHandler.getBrokerings(connection);
            arrayList.addAll(Arrays.asList(dbAgencyBrokeringArray));
            DbContactsGroup[] objectArray = dbContactsHandler.getGroups(connection);
            int n = objectArray.length;
            boolean bl = false;
            while (var13_19 < n) {
                DbContactsGroup dbContactsGroup = objectArray[var13_19];
                hashMap.put(dbContactsGroup.id, dbContactsGroup.name);
                ++var13_19;
            }
            DbAgencyBrokering[] dbAgencyBrokeringArray2 = dbAgencyBrokeringArray;
            int n2 = dbAgencyBrokeringArray2.length;
            boolean bl2 = false;
            while (var13_21 < n2) {
                DbAgencyBrokering dbAgencyBrokering = dbAgencyBrokeringArray2[var13_21];
                if (!hashMap2.containsKey(dbAgencyBrokering.contactsEntryId)) {
                    hashMap2.put(dbAgencyBrokering.contactsEntryId, null);
                }
                if (!hashMap3.containsKey(dbAgencyBrokering.agencyObjectId)) {
                    hashMap3.put(dbAgencyBrokering.agencyObjectId, null);
                }
                ++var13_21;
            }
            DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntries(connection, ArrayUtils.toPrimitive((Long[])hashMap2.keySet().toArray(new Long[0])));
            dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
            DbContactsEntry[] dbContactsEntryArray2 = dbContactsEntryArray;
            int n3 = dbContactsEntryArray2.length;
            boolean bl3 = false;
            while (var14_28 < n3) {
                DbContactsEntry dbContactsEntry = dbContactsEntryArray2[var14_28];
                hashMap2.put(dbContactsEntry.id, dbContactsEntry);
                ++var14_28;
            }
            DbObject[] dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, ArrayUtils.toPrimitive((Long[])hashMap3.keySet().toArray(new Long[0])));
            dbAgencyObjectsHandler.loadObjectTranslations(connection, dbObjectArray, dbLanguagesHandler);
            for (DbObject dbObject : dbObjectArray) {
                hashMap3.put(dbObject.id, (DbAgencyObject)dbObject);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, hashMap2, hashMap3, hashMap){
                final /* synthetic */ List val$brokeringsList;
                final /* synthetic */ Map val$contactsEntryMap;
                final /* synthetic */ Map val$agencyObjectMap;
                final /* synthetic */ Map val$contactsGroupNameMap;
                {
                    this.val$brokeringsList = list;
                    this.val$contactsEntryMap = map;
                    this.val$agencyObjectMap = map2;
                    this.val$contactsGroupNameMap = map3;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (DbAgencyBrokering dbAgencyBrokering : this.val$brokeringsList) {
                            String string;
                            DbContactsEntry dbContactsEntry = dbAgencyBrokering.contactsEntryId > 0L && this.val$contactsEntryMap.containsKey(dbAgencyBrokering.contactsEntryId) ? (DbContactsEntry)this.val$contactsEntryMap.get(dbAgencyBrokering.contactsEntryId) : null;
                            DbAgencyObject dbAgencyObject = dbAgencyBrokering.agencyObjectId > 0L && this.val$agencyObjectMap.containsKey(dbAgencyBrokering.agencyObjectId) ? (DbAgencyObject)this.val$agencyObjectMap.get(dbAgencyBrokering.agencyObjectId) : null;
                            String string2 = string = dbContactsEntry != null && dbContactsEntry.groupId > 0L && this.val$contactsGroupNameMap.containsKey(dbContactsEntry.groupId) ? (String)this.val$contactsGroupNameMap.get(dbContactsEntry.groupId) : I18N.tr("unknown");
                            if (dbContactsEntry == null) {
                                dbContactsEntry = new DbContactsEntry();
                                dbContactsEntry.id = dbAgencyBrokering.contactsEntryId;
                                dbContactsEntry.address = new CompanyAddressImpl();
                                dbContactsEntry.address.setPersonLastName(I18N.tr("unknown"));
                                if (!AgencyBrokeringTablePanel.this.unknownAddressIds.contains(dbAgencyBrokering.contactsEntryId)) {
                                    AgencyBrokeringTablePanel.this.unknownAddressIds.add(dbAgencyBrokering.contactsEntryId);
                                }
                            }
                            AgencyBrokeringTablePanel.this.table.addRow((AbstractTable.Row)new AgencyBrokeringTable.Row(dbAgencyBrokering, dbAgencyObject, dbContactsEntry, string));
                        }
                    }
                    finally {
                        AgencyBrokeringTablePanel.this.table.setEnabled(true);
                        AgencyBrokeringTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new BrokeringViewAction()));
        jPopupMenu.add((Action)((Object)new BrokeringRemoveAction()));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new AgencyObjectViewAction()));
        JMenu jMenu = new JMenu(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_user.png", (int)16));
        jMenu.add((Action)((Object)new ContactsEntryViewAction()));
        jPopupMenu.add(jMenu);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n3 : this.table.getSelectedRows()) {
            int entryTableExtension = this.table.convertRowIndexToModel(n3);
            long objectArray2 = this.table.getContactEntryIdAt(entryTableExtension);
            if (this.unknownAddressIds.contains(objectArray2) || arrayList.contains(objectArray2)) continue;
            arrayList.add(objectArray2);
        }
        if (arrayList.isEmpty()) {
            jMenu.setEnabled(false);
        } else {
            Long[] longArray = arrayList.toArray(new Long[0]);
            for (EntryTableExtension entryTableExtension : this.table.getAddons()) {
                Object[] objectArray = entryTableExtension.createActionMenuItems(ImmoToolProject.getAppInstance(), longArray, (JComponent)((Object)this));
                if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                for (Object object : objectArray) {
                    jMenu.add((JMenuItem)object);
                }
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("table of brokering mandates"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("brokerings"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of brokering mandates.");
    }

    protected String getTableTitle() {
        int n;
        Object object = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            object = (String)object + " / ";
            object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return object;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.filterIdLabel.setText(I18N.tr("ID") + ":");
        this.filterPersonLabel.setText(StringUtils.capitalize((String)I18N.tr("person")) + ":");
        this.filterAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.filterStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
    }

    private class ContactsEntryViewAction
    extends AbstractI18nAction {
        private ContactsEntryViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AgencyBrokeringTablePanel.this.table.getSelectedRowCount() < 1) {
                return;
            }
            int n = AgencyBrokeringTablePanel.this.table.convertRowIndexToModel(AgencyBrokeringTablePanel.this.table.getSelectedRow());
            long l = AgencyBrokeringTablePanel.this.table.getContactEntryIdAt(n);
            new ContactsPlugin.EntryFormAction(l).actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the address."));
        }
    }

    private class BrokeringViewAction
    extends AbstractI18nAction {
        private BrokeringViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyBrokeringTablePanel.this.doBrokeringView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show mandate")));
            this.setShortDescription(I18N.tr("Show the selected brokering mandates."));
        }
    }

    private class BrokeringRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] brokeringIds;

        private BrokeringRemoveTask(long[] lArray) {
            this.brokeringIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbAgencyBrokeringsHandler.removeBrokerings(connection, this.brokeringIds);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove brokering requests!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyBrokeringTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            for (long l : this.brokeringIds) {
                int n = AgencyBrokeringTablePanel.this.table.getRowForBrokeringId(l);
                if (n <= -1) continue;
                AgencyBrokeringTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class BrokeringRemoveAction
    extends AbstractI18nAction {
        private BrokeringRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyBrokeringTablePanel.this.doBrokeringRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove mandate")));
            this.setShortDescription(I18N.tr("Remove the selected brokering mandates."));
        }
    }

    private static class BrokeringAddAction
    extends AbstractI18nAction {
        private BrokeringAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AgencyContactsUtils.BrokeringFormAction().actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new brokering mandate."));
        }
    }

    private class AgencyObjectViewAction
    extends AbstractI18nAction {
        private AgencyObjectViewAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AgencyBrokeringTablePanel.this.table.getSelectedRowCount() < 1) {
                return;
            }
            int n = AgencyBrokeringTablePanel.this.table.convertRowIndexToModel(AgencyBrokeringTablePanel.this.table.getSelectedRow());
            long l = AgencyBrokeringTablePanel.this.table.getAgencyObjectIdAt(n);
            new AgencyPlugin.EstateFormAction(l).actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class Table
    extends AgencyBrokeringTable {
        public Table() {
            super(AgencyBrokeringTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            AgencyBrokeringTablePanel.this.doBrokeringRemove();
        }

        protected void doSelect() {
            AgencyBrokeringTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            AgencyBrokeringTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyBrokeringTablePanel.this.doBrokeringView();
        }
    }
}

