/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.daft_ie;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.LocaleUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.daft_ie.DaftIeDocument;
import org.openestate.io.daft_ie.DaftIeVersion;
import org.openestate.io.daft_ie.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DaftIeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaftIeUtils.class);
    private static JAXBContext JAXB = null;
    public static final DaftIeVersion VERSION = DaftIeVersion.V2_7;
    public static final String NAMESPACE = "";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String PACKAGE = "org.openestate.io.daft_ie.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private DaftIeUtils() {
    }

    public static DaftIeDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return DaftIeUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static DaftIeDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return DaftIeUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static DaftIeDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return DaftIeUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static DaftIeDocument createDocument(Document document) {
        if (DaftIeDocument.isReadable(document)) {
            return new DaftIeDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return DaftIeUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = DaftIeUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = DaftIeUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            DaftIeUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static String getCountryName(String string) {
        return LocaleUtils.getCountryName((String)string, (Locale)DEFAULT_LOCALE);
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static Boolean parseBoolean(String string) {
        if ("1".equals(string = StringUtils.trimToEmpty((String)string))) {
            return Boolean.TRUE;
        }
        if ("0".equals(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Can't parse boolean value '" + string + "'!");
    }

    public static String parseCountry(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static Calendar parseDate(String string) {
        return XmlUtils.parseDate((String)string);
    }

    public static Calendar parseDateTime(String string) {
        return XmlUtils.parseDateTime((String)string);
    }

    public static BigDecimal parsePositiveDecimal(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigInteger parsePositiveInteger(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseInteger((String)string) : null;
    }

    public static URI parseURI(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            if (StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"http://")) {
                return new URI(string);
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"https://")) {
                return new URI(string);
            }
            return new URI("http://" + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can't parse URI value '" + string + "'!", uRISyntaxException);
        }
    }

    public static String printBoolean(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "1";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "0";
        }
        throw new IllegalArgumentException("Can't print boolean value!");
    }

    public static String printCountry(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            throw new IllegalArgumentException("Can't print country value!");
        }
        String string2 = StringUtils.trimToNull((String)DaftIeUtils.getCountryName(string));
        if (string2 == null) {
            LOGGER.warn("Can't convert country '" + string + "' to its english name!");
            return string;
        }
        return string2;
    }

    public static String printDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date value!");
        }
        return DaftIeUtils.getDateFormat().format(calendar.getTime());
    }

    public static String printDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date-time value!");
        }
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }

    public static String printPositiveDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("Can't print positive double value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printPositiveInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 1) {
            throw new IllegalArgumentException("Can't print positive integer value!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printURI(URI uRI) {
        if (uRI == null || StringUtils.isBlank((CharSequence)uRI.getHost())) {
            throw new IllegalArgumentException("Can't print URI value!");
        }
        return uRI.toString();
    }
}

