/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.wis_it;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.wis_it.WisItDocument;
import org.openestate.io.wis_it.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WisItUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisItUtils.class);
    private static JAXBContext JAXB = null;
    public static final String NAMESPACE = "";
    public static final String PACKAGE = "org.openestate.io.wis_it.xml";
    private static final ObjectFactory FACTORY = new ObjectFactory();

    private WisItUtils() {
    }

    public static WisItDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return WisItUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static WisItDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return WisItUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static WisItDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return WisItUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static WisItDocument createDocument(Document document) {
        if (WisItDocument.isReadable(document)) {
            return new WisItDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return WisItUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = WisItUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = WisItUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            WisItUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static Calendar parseDateTime(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            Date date = DateUtils.parseDateStrictly((String)string, (String[])new String[]{"yyyy-MM-dd mm:hh:ss", "yyyy-MM-dd mm:hh", "yyyy-MM-dd"});
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException parseException) {
            try {
                return XmlUtils.parseDateTime((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Can't parse date-time value '" + string + "'!");
            }
        }
    }

    public static BigDecimal parseDecimal(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseDouble(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigInteger parsePositiveInteger(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseInteger((String)string) : null;
    }

    public static Boolean parseYesNo(String string) {
        if ("ja".equalsIgnoreCase(string = StringUtils.trimToNull((String)string))) {
            return Boolean.TRUE;
        }
        if ("nein".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if (string != null) {
            return DatatypeConverter.parseBoolean((String)string);
        }
        throw new IllegalArgumentException("Can't parse boolean value!");
    }

    public static String printDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print date-time value!");
        }
        return WisItUtils.getDateTimeFormat().format(calendar.getTime());
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print decimal value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal.setScale(2, 4));
    }

    public static String printDouble(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print double value!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printPositiveInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.compareTo(BigInteger.ZERO) < 1) {
            throw new IllegalArgumentException("Can't print positive integer value!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printYesNo(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "ja";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "nein";
        }
        throw new IllegalArgumentException("Can't print boolean value!");
    }
}

