-- -----------------------------------------------------
-- Contacts extensions to the Agency-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

CREATE SEQUENCE seq_immotool_agency_brokerings
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;
CREATE SEQUENCE seq_immotool_agency_interests
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;

-- -----------------------------------------------------
-- Table immotool_agency_brokerings
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_agency_brokerings (
  brokering_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_agency_brokerings NOT NULL,
  contacts_entry_id BIGINT NOT NULL,
  agency_object_id BIGINT NOT NULL,
  brokering_exclusive BOOLEAN DEFAULT FALSE NOT NULL,
  brokering_begin TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  brokering_end TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  brokering_notes LONGVARCHAR DEFAULT NULL NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (brokering_id),
  UNIQUE (agency_object_id),
  FOREIGN KEY (contacts_entry_id)
    REFERENCES immotool_contacts_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (agency_object_id)
    REFERENCES openestate_objects(object_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_agency_brokerings AS
  SELECT a.* FROM immotool_agency_brokerings a
  INNER JOIN immotool_agency_objects b ON ( a.agency_object_id = b.object_id )
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(b.access_permissions, 64) = 64)
    OR
    (BITAND(b.access_permissions, 8) = 8 AND b.access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(b.access_permissions, 1) = 1 AND b.access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

GRANT SELECT
  ON view_immotool_agency_brokerings
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_agency_interests
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_agency_interests (
  interest_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_agency_interests NOT NULL,
  contacts_entry_id BIGINT NOT NULL,
  agency_search_id BIGINT NOT NULL,
  interest_status VARCHAR(100) NULL,
  interest_begin TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  interest_end TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  interest_notes LONGVARCHAR DEFAULT NULL NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (interest_id),
  FOREIGN KEY (contacts_entry_id)
    REFERENCES immotool_contacts_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (agency_search_id)
    REFERENCES immotool_agency_searches(search_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_agency_interests AS
  SELECT * FROM immotool_agency_interests
  WHERE contacts_entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);

GRANT SELECT
  ON view_immotool_agency_interests
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_agency_interests_offers
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_agency_interests_offers (
  interest_id BIGINT NOT NULL,
  agency_object_id BIGINT NOT NULL,
  offer_time TIMESTAMP WITH TIME ZONE NOT NULL,
  offer_status VARCHAR(100) NOT NULL,
  offer_notes LONGVARCHAR DEFAULT NULL NULL,
  PRIMARY KEY (interest_id, agency_object_id),
  FOREIGN KEY (interest_id)
    REFERENCES immotool_agency_interests(interest_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (agency_object_id)
    REFERENCES openestate_objects(object_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_agency_interests_offers AS
  SELECT * FROM immotool_agency_interests_offers
  WHERE interest_id IN (SELECT interest_id FROM view_immotool_agency_interests)
  AND agency_object_id IN (SELECT object_id FROM view_openestate_objects);

GRANT SELECT
  ON view_immotool_agency_interests_offers
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_agency_objects_contacts_entries
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_agency_objects_contacts_entries (
  agency_object_id BIGINT NOT NULL,
  contacts_entry_id BIGINT NOT NULL,
  relation_type VARCHAR(100) DEFAULT NULL NULL,
  relation_notes LONGVARCHAR DEFAULT NULL NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (agency_object_id, contacts_entry_id),
  FOREIGN KEY (agency_object_id)
    REFERENCES openestate_objects(object_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (contacts_entry_id)
    REFERENCES immotool_contacts_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_agency_objects_contacts_entries AS
  SELECT * FROM immotool_agency_objects_contacts_entries
  WHERE agency_object_id IN (SELECT object_id FROM view_openestate_objects)
  AND contacts_entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);

GRANT SELECT
  ON view_immotool_agency_objects_contacts_entries
  TO "IMMOTOOL";
