-- -----------------------------------------------------
-- Contacts extensions to the Agency-Addon for OpenEstate-ImmoTool
-- update 8 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Update procedure 'remove_immotool_agency_objects_contacts_entries'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_agency_objects_contacts_entries
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_agency_objects_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    IF val_agency_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_contacts_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Lese-Rechte besitzt
    IF NOT is_admin() = TRUE THEN

      -- Lese-Rechte auf der Immobilie müssen vorliegen
      IF NOT can_read_immotool_agency_objects( val_agency_object_id ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

      -- Lese-Rechte auf dem Adresseintrag müssen vorliegen
      IF NOT can_read_immotool_contacts_entries( val_contacts_entry_id ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

    END IF;

    -- Relation entfernen
    DELETE
      FROM immotool_agency_objects_contacts_entries
      WHERE agency_object_id = val_agency_object_id
      AND contacts_entry_id = val_contacts_entry_id;

  END;
.;
