-- -----------------------------------------------------
-- Contacts extensions to the Agency-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_brokerings'
-- Rebuild view 'view_immotool_agency_interests'
-- Rebuild function 'can_delete_immotool_agency_brokerings'
-- Rebuild function 'can_delete_immotool_agency_interests'
-- Rebuild function 'can_write_immotool_agency_brokerings'
-- Rebuild function 'can_write_immotool_agency_interests'
-- Rebuild procedure 'save_immotool_agency_brokerings'
-- Rebuild procedure 'save_immotool_agency_interests'
-- Drop permission columns from 'immotool_agency_brokerings'
-- Drop permission columns from 'immotool_agency_interests'
-- -----------------------------------------------------


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_brokerings'
-- -----------------------------------------------------
ALTER VIEW view_immotool_agency_brokerings AS
  SELECT
    a.brokering_id,
    a.contacts_entry_id,
    a.agency_object_id,
    a.brokering_exclusive,
    a.brokering_begin,
    a.brokering_end,
    a.brokering_notes,
    a.created_at,
    a.modified_at
  FROM immotool_agency_brokerings a
  INNER JOIN immotool_agency_objects b ON ( a.agency_object_id = b.object_id )
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(b.access_permissions, 64) = 64)
    OR
    (BITAND(b.access_permissions, 8) = 8 AND b.access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(b.access_permissions, 1) = 1 AND b.access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_interests'
-- -----------------------------------------------------
ALTER VIEW view_immotool_agency_interests AS
  SELECT
    interest_id,
    contacts_entry_id,
    agency_search_id,
    interest_status,
    interest_begin,
    interest_end,
    interest_notes,
    created_at,
    modified_at
  FROM immotool_agency_interests
  WHERE contacts_entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);


-- -----------------------------------------------------
-- Rebuild function 'can_delete_immotool_agency_brokerings'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE can_delete_immotool_agency_brokerings
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen (Schreibrechte auf der zugewiesenen Immobilie)
    SELECT obj.access_permissions, obj.access_owner_id, obj.access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_brokerings brok, immotool_agency_objects obj
      WHERE brok.brokering_id = val_brokering_id AND brok.agency_object_id = obj.object_id;

    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild function 'can_delete_immotool_agency_interests'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE can_delete_immotool_agency_interests
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen (Schreibrechte auf der zugewiesenen Adresse)
    SELECT addrgrp.access_permissions, addrgrp.access_owner_id, addrgrp.access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_interests intr, immotool_contacts_entries addr, immotool_contacts_groups addrgrp
      WHERE intr.interest_id = val_interest_id AND intr.contacts_entry_id = addr.entry_id AND addr.group_id = addrgrp.group_id;

    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild function 'can_write_immotool_agency_brokerings'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE can_write_immotool_agency_brokerings
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen (Leserechte auf der zugewiesenen Immobilie)
    SELECT obj.access_permissions, obj.access_owner_id, obj.access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_brokerings brok, immotool_agency_objects obj
      WHERE brok.brokering_id = val_brokering_id AND brok.agency_object_id = obj.object_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild function 'can_write_immotool_agency_interests'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE can_write_immotool_agency_interests
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen (Leserechte auf der zugewiesenen Adresse)
    SELECT addrgrp.access_permissions, addrgrp.access_owner_id, addrgrp.access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_agency_interests intr, immotool_contacts_entries addr, immotool_contacts_groups addrgrp
      WHERE intr.interest_id = val_interest_id AND intr.contacts_entry_id = addr.entry_id AND addr.group_id = addrgrp.group_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_brokerings'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_immotool_agency_brokerings;

\.
CREATE PROCEDURE save_immotool_agency_brokerings(
    INOUT val_brokering_id BIGINT,
    val_contacts_entry_id BIGINT,
    val_agency_object_id BIGINT,
    val_brokering_exclusive BOOLEAN,
    val_brokering_begin TIMESTAMP WITH TIME ZONE,
    val_brokering_end TIMESTAMP WITH TIME ZONE,
    val_brokering_notes LONGVARCHAR
  )
  SPECIFIC save_immotool_agency_brokerings
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass Schreibrechte auf der zugewiesenen Immobilie vorliegen
    SET allowed = can_write_immotool_agency_objects( val_agency_object_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neue Vermarktung erzeugen
    IF val_brokering_id < 1 THEN

      -- Vermarktung speichern
      INSERT INTO immotool_agency_brokerings (
        contacts_entry_id,
        agency_object_id,
        brokering_exclusive,
        brokering_begin,
        brokering_end,
        brokering_notes )
      VALUES (
        val_contacts_entry_id,
        val_agency_object_id,
        val_brokering_exclusive,
        val_brokering_begin,
        val_brokering_end,
        val_brokering_notes);

      -- ID zurückliefern
      SET val_brokering_id = IDENTITY();

    -- Bestehende Vermarktung bearbeiten
    ELSE

      -- Vermarktung bearbeiten
      UPDATE immotool_agency_brokerings
        SET
          contacts_entry_id = val_contacts_entry_id,
          agency_object_id = val_agency_object_id,
          brokering_exclusive = val_brokering_exclusive,
          brokering_begin = val_brokering_begin,
          brokering_end = val_brokering_end,
          brokering_notes = val_brokering_notes,
          modified_at = NOW()
        WHERE
          brokering_id = val_brokering_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_brokerings
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_interests'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_immotool_agency_interests;

\.
CREATE PROCEDURE save_immotool_agency_interests(
    INOUT val_interest_id BIGINT,
    val_contacts_entry_id BIGINT,
    val_agency_search_id BIGINT,
    val_interest_status VARCHAR(100),
    val_interest_begin TIMESTAMP WITH TIME ZONE,
    val_interest_end TIMESTAMP WITH TIME ZONE,
    val_interest_notes LONGVARCHAR
  )
  SPECIFIC save_immotool_agency_interests
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass Schreibrechte auf der zugewiesenen Adresse vorliegen
    SET allowed = can_write_immotool_contacts_entries( val_contacts_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Interessent erzeugen
    IF val_interest_id < 1 THEN

      -- Interessent speichern
      INSERT INTO immotool_agency_interests (
        contacts_entry_id,
        agency_search_id,
        interest_status,
        interest_begin,
        interest_end,
        interest_notes )
      VALUES (
        val_contacts_entry_id,
        val_agency_search_id,
        val_interest_status,
        val_interest_begin,
        val_interest_end,
        val_interest_notes);

      -- ID zurückliefern
      SET val_interest_id = IDENTITY();

    -- Bestehenden Interessent bearbeiten
    ELSE

      -- Interessent bearbeiten
      UPDATE immotool_agency_interests
        SET
          contacts_entry_id = val_contacts_entry_id,
          agency_search_id = val_agency_search_id,
          interest_status = val_interest_status,
          interest_begin = val_interest_begin,
          interest_end = val_interest_end,
          interest_notes = val_interest_notes,
          modified_at = NOW()
        WHERE
          interest_id = val_interest_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_interests
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Drop permission columns from 'immotool_agency_brokerings'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_brokerings
  DROP COLUMN access_owner_id CASCADE;
ALTER TABLE immotool_agency_brokerings
  DROP COLUMN access_group_id CASCADE;
ALTER TABLE immotool_agency_brokerings
  DROP COLUMN access_permissions CASCADE;


-- -----------------------------------------------------
-- Drop permission columns from 'immotool_agency_interests'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_interests
  DROP COLUMN access_owner_id CASCADE;
ALTER TABLE immotool_agency_interests
  DROP COLUMN access_group_id CASCADE;
ALTER TABLE immotool_agency_interests
  DROP COLUMN access_permissions CASCADE;
