-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 13 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Create table 'immotool_agency_exports_logs_messages'
-- Create view 'view_immotool_agency_exports_logs_messages'
-- Load export log messages into table 'immotool_agency_exports_logs_messages'
-- Add field 'log_count_warnings' to 'immotool_agency_exports_logs'
-- Add field 'log_count_notices' to 'immotool_agency_exports_logs'
-- Add procedure 'remove_immotool_agency_exports_logs_messages'
-- Add procedure 'save_immotool_agency_exports_logs_messages'
-- Rebuild procedure 'save_immotool_agency_exports_logs_entries'
-- Rebuild procedure 'save_immotool_agency_exports_logs'
-- Rebuild view 'view_immotool_agency_exports_logs_entries'
-- Rebuild view 'view_immotool_agency_exports_logs'
-- Drop field 'entry_message' from 'immotool_agency_exports_logs_entries'
-- Update 'access_*' fields in 'immotool_agency_objects'
-- Update 'access_*' fields in 'immotool_agency_contacts'
-- Update 'access_*' fields in 'immotool_agency_exposes'
-- Update 'access_*' fields in 'immotool_agency_searches'
-- Update 'access_*' fields in 'immotool_agency_exports'
-- -----------------------------------------------------


-- -----------------------------------------------------
-- Create table 'immotool_agency_exports_logs_messages'
-- -----------------------------------------------------

CREATE CACHED TABLE immotool_agency_exports_logs_messages (
  log_id BIGINT NOT NULL,
  entry_object_id BIGINT NOT NULL,
  message_level VARCHAR(10) NOT NULL,
  message_code VARCHAR(255) DEFAULT NULL NULL,
  message_text LONGVARCHAR NOT NULL,
  FOREIGN KEY (log_id)
    REFERENCES immotool_agency_exports_logs(log_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);


-- -----------------------------------------------------
-- Create view 'view_immotool_agency_exports_logs_messages'
-- -----------------------------------------------------

CREATE VIEW view_immotool_agency_exports_logs_messages AS
  SELECT * FROM immotool_agency_exports_logs_messages
  WHERE log_id IN (SELECT log_id FROM view_immotool_agency_exports_logs);

GRANT SELECT
  ON view_immotool_agency_exports_logs_messages
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Load export log messages into table 'immotool_agency_exports_logs_messages'
-- -----------------------------------------------------

INSERT INTO immotool_agency_exports_logs_messages (log_id, entry_object_id, message_level, message_text)
  (SELECT e.log_id, e.entry_object_id, 'ERROR', e.entry_message
    FROM immotool_agency_exports_logs_entries e
    WHERE e.entry_exported = FALSE
    AND e.entry_message IS NOT NULL
    AND LENGTH(e.entry_message)>0 );

INSERT INTO immotool_agency_exports_logs_messages (log_id, entry_object_id, message_level, message_text)
  (SELECT e.log_id, e.entry_object_id, 'NOTICE', e.entry_message
    FROM immotool_agency_exports_logs_entries e
    WHERE e.entry_exported = TRUE
    AND e.entry_message IS NOT NULL
    AND LENGTH(e.entry_message)>0 );


-- -----------------------------------------------------
-- Add field 'log_count_warnings' to 'immotool_agency_exports_logs'
-- -----------------------------------------------------

ALTER TABLE immotool_agency_exports_logs
  ADD COLUMN log_count_warnings INT DEFAULT 0 NOT NULL
  BEFORE log_time;


-- -----------------------------------------------------
-- Add field 'log_count_notices' to 'immotool_agency_exports_logs'
-- -----------------------------------------------------

ALTER TABLE immotool_agency_exports_logs
  ADD COLUMN log_count_notices INT DEFAULT 0 NOT NULL
  BEFORE log_time;


-- -----------------------------------------------------
-- Add procedure 'remove_immotool_agency_exports_logs_messages'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_immotool_agency_exports_logs_messages(
    val_log_id BIGINT,
    val_entry_object_id BIGINT
  )
  SPECIFIC remove_immotool_agency_exports_logs_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_export_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_log_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT export_id
      INTO val_export_id
      FROM immotool_agency_exports_logs
      WHERE log_id = val_log_id;
    SET allowed = can_write_immotool_agency_exports( val_export_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Spezifischen Eintrag entfernen
    IF val_entry_object_id IS NOT NULL THEN

      DELETE
        FROM immotool_agency_exports_logs_messages
        WHERE log_id = val_log_id
        AND entry_object_id = val_entry_object_id;

    -- Einträge eines Logs entfernen
    ELSE

      DELETE
        FROM immotool_agency_exports_logs_messages
        WHERE log_id = val_log_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_agency_exports_logs_messages
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Add procedure 'save_immotool_agency_exports_logs_messages'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_agency_exports_logs_messages(
    val_log_id BIGINT,
    val_entry_object_id BIGINT,
    val_message_level VARCHAR(10),
    val_message_code VARCHAR(255),
    val_message_text LONGVARCHAR
  )
  SPECIFIC save_immotool_agency_exports_logs_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_export_id BIGINT;
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT export_id
      INTO val_export_id
      FROM immotool_agency_exports_logs
      WHERE log_id = val_log_id;
    IF NOT allowed = TRUE AND val_export_id IS NOT NULL AND val_export_id > 0 THEN
      SET allowed = can_write_immotool_agency_exports( val_export_id );
    END IF;
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag speichern
    INSERT INTO immotool_agency_exports_logs_messages (
      log_id,
      entry_object_id,
      message_level,
      message_code,
      message_text )
    VALUES (
      val_log_id,
      val_entry_object_id,
      val_message_level,
      val_message_code,
      val_message_text );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_exports_logs_messages
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_exports_logs_entries'
-- -----------------------------------------------------

DROP PROCEDURE
  IF EXISTS save_immotool_agency_exports_logs_entries;

\.
CREATE PROCEDURE save_immotool_agency_exports_logs_entries(
    val_log_id BIGINT,
    val_entry_object_id BIGINT,
    val_entry_object_nr VARCHAR(255),
    val_entry_action VARCHAR(10),
    val_entry_exported BOOLEAN
  )
  SPECIFIC save_immotool_agency_exports_logs_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_export_id BIGINT;
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT export_id
      INTO val_export_id
      FROM immotool_agency_exports_logs
      WHERE log_id = val_log_id;
    IF NOT allowed = TRUE AND val_export_id IS NOT NULL AND val_export_id > 0 THEN
      SET allowed = can_write_immotool_agency_exports( val_export_id );
    END IF;
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- ggf. existierenden Eintrag entfernen
    DELETE
      FROM immotool_agency_exports_logs_entries
      WHERE log_id = val_log_id
      AND entry_object_id = val_entry_object_id;

    -- Eintrag speichern
    INSERT INTO immotool_agency_exports_logs_entries (
      log_id,
      entry_object_id,
      entry_object_nr,
      entry_action,
      entry_exported )
    VALUES (
      val_log_id,
      val_entry_object_id,
      val_entry_object_nr,
      val_entry_action,
      val_entry_exported );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_exports_logs_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_exports_logs'
-- -----------------------------------------------------

DROP PROCEDURE
  IF EXISTS save_immotool_agency_exports_logs;

\.
CREATE PROCEDURE save_immotool_agency_exports_logs(
    INOUT val_log_id BIGINT,
    val_export_id BIGINT,
    val_log_format VARCHAR(100),
    val_log_transport VARCHAR(100),
    val_log_transfer VARCHAR(100),
    val_log_limit INT,
    val_log_count_inserts INT,
    val_log_count_updates INT,
    val_log_count_deletes INT,
    val_log_count_errors INT,
    val_log_count_warnings INT,
    val_log_count_notices INT,
    val_log_time TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_immotool_agency_exports_logs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    IF NOT allowed = TRUE AND val_export_id IS NOT NULL AND val_export_id > 0 THEN
      SET allowed = can_write_immotool_agency_exports( val_export_id );
    END IF;
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neues Log
    IF val_log_id < 1 THEN

      -- Log speichern
      INSERT INTO immotool_agency_exports_logs (
        export_id,
        log_format,
        log_transport,
        log_transfer,
        log_limit,
        log_count_inserts,
        log_count_updates,
        log_count_deletes,
        log_count_errors,
        log_count_warnings,
        log_count_notices,
        log_time )
      VALUES (
        val_export_id,
        val_log_format,
        val_log_transport,
        val_log_transfer,
        val_log_limit,
        val_log_count_inserts,
        val_log_count_updates,
        val_log_count_deletes,
        val_log_count_errors,
        val_log_count_warnings,
        val_log_count_notices,
        val_log_time );

      -- ID zurückliefern
      SET val_log_id = IDENTITY();

    ELSE

      -- Log bearbeiten
      UPDATE immotool_agency_exports_logs
        SET
          export_id = val_export_id,
          log_format = val_log_format,
          log_transport = val_log_transport,
          log_transfer = val_log_transfer,
          log_limit = val_log_limit,
          log_count_inserts = val_log_count_inserts,
          log_count_updates = val_log_count_updates,
          log_count_deletes = val_log_count_deletes,
          log_count_errors = val_log_count_errors,
          log_count_warnings = val_log_count_warnings,
          log_count_notices = val_log_count_notices,
          log_time = val_log_time
        WHERE
          log_id = val_log_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_exports_logs
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_exports_logs_entries'
-- -----------------------------------------------------

ALTER VIEW view_immotool_agency_exports_logs_entries AS
  SELECT
    log_id,
    entry_object_id,
    entry_object_nr,
    entry_action,
    entry_exported
  FROM immotool_agency_exports_logs_entries
  WHERE log_id IN (SELECT log_id FROM view_immotool_agency_exports_logs);


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_exports_logs'
-- -----------------------------------------------------

ALTER VIEW view_immotool_agency_exports_logs AS
  SELECT * FROM immotool_agency_exports_logs
  WHERE export_id IN (SELECT export_id FROM view_immotool_agency_exports);


-- -----------------------------------------------------
-- Drop field 'entry_message' from 'immotool_agency_exports_logs_entries'
-- -----------------------------------------------------

ALTER TABLE immotool_agency_exports_logs_entries
  DROP COLUMN entry_message RESTRICT;


-- -----------------------------------------------------
-- Update 'access_*' fields in 'immotool_agency_objects'
-- -----------------------------------------------------

UPDATE immotool_agency_objects
  SET access_owner_id = 1 WHERE access_owner_id IS NULL;
UPDATE immotool_agency_objects
  SET access_group_id = 1 WHERE access_group_id IS NULL;
UPDATE immotool_agency_objects
  SET access_permissions = 0 WHERE access_permissions IS NULL;

ALTER TABLE immotool_agency_objects
  ALTER COLUMN access_owner_id SET DEFAULT 1;
ALTER TABLE immotool_agency_objects
  ALTER COLUMN access_group_id SET DEFAULT 1;
ALTER TABLE immotool_agency_objects
  ALTER COLUMN access_permissions SET DEFAULT 0;

ALTER TABLE immotool_agency_objects
  ALTER COLUMN access_owner_id SET NOT NULL;
ALTER TABLE immotool_agency_objects
  ALTER COLUMN access_group_id SET NOT NULL;
ALTER TABLE immotool_agency_objects
  ALTER COLUMN access_permissions SET NOT NULL;


-- -----------------------------------------------------
-- Update 'access_*' fields in 'immotool_agency_contacts'
-- -----------------------------------------------------

UPDATE immotool_agency_contacts
  SET access_owner_id = 1 WHERE access_owner_id IS NULL;
UPDATE immotool_agency_contacts
  SET access_group_id = 1 WHERE access_group_id IS NULL;
UPDATE immotool_agency_contacts
  SET access_permissions = 0 WHERE access_permissions IS NULL;

ALTER TABLE immotool_agency_contacts
  ALTER COLUMN access_owner_id SET DEFAULT 1;
ALTER TABLE immotool_agency_contacts
  ALTER COLUMN access_group_id SET DEFAULT 1;
ALTER TABLE immotool_agency_contacts
  ALTER COLUMN access_permissions SET DEFAULT 0;

ALTER TABLE immotool_agency_contacts
  ALTER COLUMN access_owner_id SET NOT NULL;
ALTER TABLE immotool_agency_contacts
  ALTER COLUMN access_group_id SET NOT NULL;
ALTER TABLE immotool_agency_contacts
  ALTER COLUMN access_permissions SET NOT NULL;


-- -----------------------------------------------------
-- Update 'access_*' fields in 'immotool_agency_exposes'
-- -----------------------------------------------------

UPDATE immotool_agency_exposes
  SET access_owner_id = 1 WHERE access_owner_id IS NULL;
UPDATE immotool_agency_exposes
  SET access_group_id = 1 WHERE access_group_id IS NULL;
UPDATE immotool_agency_exposes
  SET access_permissions = 0 WHERE access_permissions IS NULL;

ALTER TABLE immotool_agency_exposes
  ALTER COLUMN access_owner_id SET DEFAULT 1;
ALTER TABLE immotool_agency_exposes
  ALTER COLUMN access_group_id SET DEFAULT 1;
ALTER TABLE immotool_agency_exposes
  ALTER COLUMN access_permissions SET DEFAULT 0;

ALTER TABLE immotool_agency_exposes
  ALTER COLUMN access_owner_id SET NOT NULL;
ALTER TABLE immotool_agency_exposes
  ALTER COLUMN access_group_id SET NOT NULL;
ALTER TABLE immotool_agency_exposes
  ALTER COLUMN access_permissions SET NOT NULL;


-- -----------------------------------------------------
-- Update 'access_*' fields in 'immotool_agency_searches'
-- -----------------------------------------------------

UPDATE immotool_agency_searches
  SET access_owner_id = 1 WHERE access_owner_id IS NULL;
UPDATE immotool_agency_searches
  SET access_group_id = 1 WHERE access_group_id IS NULL;
UPDATE immotool_agency_searches
  SET access_permissions = 0 WHERE access_permissions IS NULL;

ALTER TABLE immotool_agency_searches
  ALTER COLUMN access_owner_id SET DEFAULT 1;
ALTER TABLE immotool_agency_searches
  ALTER COLUMN access_group_id SET DEFAULT 1;
ALTER TABLE immotool_agency_searches
  ALTER COLUMN access_permissions SET DEFAULT 0;

ALTER TABLE immotool_agency_searches
  ALTER COLUMN access_owner_id SET NOT NULL;
ALTER TABLE immotool_agency_searches
  ALTER COLUMN access_group_id SET NOT NULL;
ALTER TABLE immotool_agency_searches
  ALTER COLUMN access_permissions SET NOT NULL;


-- -----------------------------------------------------
-- Update 'access_*' fields in 'immotool_agency_exports'
-- -----------------------------------------------------

UPDATE immotool_agency_exports
  SET access_owner_id = 1 WHERE access_owner_id IS NULL;
UPDATE immotool_agency_exports
  SET access_group_id = 1 WHERE access_group_id IS NULL;
UPDATE immotool_agency_exports
  SET access_permissions = 0 WHERE access_permissions IS NULL;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN access_owner_id SET DEFAULT 1;
ALTER TABLE immotool_agency_exports
  ALTER COLUMN access_group_id SET DEFAULT 1;
ALTER TABLE immotool_agency_exports
  ALTER COLUMN access_permissions SET DEFAULT 0;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN access_owner_id SET NOT NULL;
ALTER TABLE immotool_agency_exports
  ALTER COLUMN access_group_id SET NOT NULL;
ALTER TABLE immotool_agency_exports
  ALTER COLUMN access_permissions SET NOT NULL;
