-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 2 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'object_import_hash' to table 'immotool_agency_objects'
-- -----------------------------------------------------

DROP PROCEDURE IF EXISTS save_immotool_agency_objects RESTRICT;

ALTER TABLE immotool_agency_objects
  ADD COLUMN object_import_hash VARCHAR(255) DEFAULT NULL NULL
  BEFORE object_group_nr;

ALTER VIEW view_openestate_objects AS
  SELECT
    a.*,
    b.object_status,
    b.object_export_mode,
    b.object_import_id,
    b.object_import_hash,
    b.object_group_nr,
    b.object_notes,
    b.access_owner_id,
    b.access_group_id,
    b.access_permissions
  FROM openestate_objects a
  INNER JOIN immotool_agency_objects b ON ( a.object_id = b.object_id )
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(b.access_permissions, 64) = 64)
    OR
    (BITAND(b.access_permissions, 8) = 8 AND b.access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(b.access_permissions, 1) = 1 AND b.access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

\.
CREATE PROCEDURE save_immotool_agency_objects(
  val_object_id BIGINT,
  val_object_status VARCHAR(25),
  val_object_export_mode VARCHAR(25),
  val_object_import_id VARCHAR(255),
  val_object_import_hash VARCHAR(255),
  val_object_group_nr INT,
  val_object_notes LONGVARCHAR,
  val_access_owner_id BIGINT,
  val_access_group_id BIGINT,
  val_access_permissions INT )
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_id BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Datensatz ermitteln
    SELECT object_id, access_permissions, access_owner_id, access_group_id
      INTO current_id, permissions, owner_uid, owner_gid
      FROM immotool_agency_objects
      WHERE object_id = val_object_id;

    -- Datensatz existiert noch nicht
    IF current_id IS NULL THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Immobilien-Zusatz einfügen
      INSERT INTO immotool_agency_objects (
        object_id,
        object_status,
        object_export_mode,
        object_import_id,
        object_import_hash,
        object_group_nr,
        object_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_object_id,
        val_object_status,
        val_object_export_mode,
        val_object_import_id,
        val_object_import_hash,
        val_object_group_nr,
        val_object_notes,
        owner_uid,
        owner_gid,
        permissions );

    -- Datensatz existiert bereits
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>1 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>1 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>1 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Immobilien-Zusatz aktualisieren
      UPDATE immotool_agency_objects
        SET
          object_status = val_object_status,
          object_export_mode = val_object_export_mode,
          object_import_id = val_object_import_id,
          object_import_hash = val_object_import_hash,
          object_group_nr = val_object_group_nr,
          object_notes = val_object_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions
        WHERE
          object_id = val_object_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_objects
  TO "IMMOTOOL";
