-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Replace field 'search_sticky' with 'search_type' in table 'immotool_agency_searches'
-- -----------------------------------------------------

ALTER VIEW view_openestate_searches AS
  SELECT
    a.*,
    b.search_type,
    b.search_object_status,
    b.access_owner_id,
    b.access_group_id,
    b.access_permissions
  FROM openestate_searches a
  INNER JOIN immotool_agency_searches b ON ( a.search_id = b.search_id )
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(b.access_permissions, 64) = 64)
    OR
    (BITAND(b.access_permissions, 8) = 8 AND b.access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(b.access_permissions, 1) = 1 AND b.access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()));

ALTER TABLE immotool_agency_searches
  DROP COLUMN search_sticky RESTRICT;

