-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'attrib_order' to table 'openestate_searches_attribs'
-- Add field 'value_order' to table 'openestate_searches_values'
-- Replace field 'search_sticky' with 'search_type' in table 'immotool_agency_searches'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add field 'attrib_order' to table 'openestate_searches_attribs'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_openestate_searches_attribs RESTRICT;

ALTER TABLE openestate_searches_attribs
  ADD COLUMN attrib_order BIGINT DEFAULT 0 NOT NULL;

ALTER VIEW view_openestate_searches_attribs AS
  SELECT * FROM openestate_searches_attribs
  WHERE search_id IN (SELECT search_id FROM view_openestate_searches);
\.
CREATE PROCEDURE save_openestate_searches_attribs(
    val_search_id BIGINT,
    val_attrib_group VARCHAR(255),
    val_attrib_name VARCHAR(255),
    val_attrib_equals VARCHAR(255),
    val_attrib_equals_like BOOLEAN,
    val_attrib_equals_case BOOLEAN,
    val_attrib_matches VARCHAR(255),
    val_attrib_numeric_min DECIMAL(15,2),
    val_attrib_numeric_max DECIMAL(15,2),
    val_attrib_numeric_unit VARCHAR(20),
    val_attrib_time_begin TIMESTAMP WITH TIME ZONE,
    val_attrib_time_end TIMESTAMP WITH TIME ZONE,
    val_attrib_order BIGINT
  )
  SPECIFIC save_openestate_searches_attribs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_search_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_searches(val_search_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Kriterium speichern
    INSERT INTO openestate_searches_attribs (
      search_id,
      attrib_group,
      attrib_name,
      attrib_equals,
      attrib_equals_like,
      attrib_equals_case,
      attrib_matches,
      attrib_numeric_min,
      attrib_numeric_max,
      attrib_numeric_unit,
      attrib_time_begin,
      attrib_time_end,
      attrib_order )
    VALUES (
      val_search_id,
      val_attrib_group,
      val_attrib_name,
      val_attrib_equals,
      val_attrib_equals_like,
      val_attrib_equals_case,
      val_attrib_matches,
      val_attrib_numeric_min,
      val_attrib_numeric_max,
      val_attrib_numeric_unit,
      val_attrib_time_begin,
      val_attrib_time_end,
      val_attrib_order );

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_openestate_searches_attribs
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Add field 'attrib_order' to table 'openestate_searches_attribs'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_openestate_searches_values RESTRICT;

ALTER TABLE openestate_searches_values
  ADD COLUMN value_order BIGINT DEFAULT 0 NOT NULL;

ALTER VIEW view_openestate_searches_values AS
  SELECT * FROM openestate_searches_values
  WHERE search_id IN (SELECT search_id FROM view_openestate_searches);
\.
CREATE PROCEDURE save_openestate_searches_values(
    val_search_id BIGINT,
    val_value_type VARCHAR(100),
    val_value_equals VARCHAR(255),
    val_value_equals_like BOOLEAN,
    val_value_equals_case BOOLEAN,
    val_value_order BIGINT
  )
  SPECIFIC save_openestate_searches_values
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_search_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_searches(val_search_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Kriterium speichern
    INSERT INTO openestate_searches_values (
      search_id,
      value_type,
      value_equals,
      value_equals_like,
      value_equals_case,
      value_order )
    VALUES (
      val_search_id,
      val_value_type,
      val_value_equals,
      val_value_equals_like,
      val_value_equals_case,
      val_value_order );

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_openestate_searches_values
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Replace field 'search_sticky' with 'search_type' in table 'immotool_agency_searches'
-- -----------------------------------------------------

DROP PROCEDURE IF EXISTS save_immotool_agency_searches RESTRICT;

ALTER TABLE immotool_agency_searches
  ADD COLUMN search_type VARCHAR(10) DEFAULT 'TEMP' NOT NULL
  BEFORE search_sticky;

UPDATE immotool_agency_searches
  SET search_type = 'SIDEBAR'
  WHERE search_sticky = TRUE;
\.
CREATE PROCEDURE save_immotool_agency_searches(
    val_search_id BIGINT,
    val_search_type VARCHAR(10),
    val_search_object_status VARCHAR(255),
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_agency_searches
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_id BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Datensatz ermitteln
    SELECT search_id, access_permissions, access_owner_id, access_group_id
      INTO current_id, permissions, owner_uid, owner_gid
      FROM immotool_agency_searches
      WHERE search_id = val_search_id;

    -- Datensatz existiert noch nicht
    IF current_id IS NULL THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Suche-Zusatz einfügen
      INSERT INTO immotool_agency_searches (
        search_id,
        search_type,
        search_object_status,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_search_id,
        val_search_type,
        val_search_object_status,
        owner_uid,
        owner_gid,
        permissions );

    -- Datensatz existiert bereits
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>1 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>1 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>1 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Suche-Zusatz aktualisieren
      UPDATE immotool_agency_searches
        SET
          search_type = val_search_type,
          search_object_status = val_search_object_status,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions
        WHERE
          search_id = val_search_id;

    END IF;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_searches
  TO "IMMOTOOL";
