-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 12 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'search_id' to table 'immotool_agency_exports'
-- Add field 'expose_id' to table 'immotool_agency_exports'
-- Add field 'export_notes' to table 'immotool_agency_exports'
-- Add field 'export_format' to table 'immotool_agency_exports'
-- Add field 'export_transport' to table 'immotool_agency_exports'
-- Add field 'export_transfer' to table 'immotool_agency_exports'
-- Add field 'export_lock_time' to table 'immotool_agency_exports'
-- Add field 'log_transfer' to table 'immotool_agency_exports_logs'
-- Add field 'log_count_inserts' to table 'immotool_agency_exports_logs'
-- Add field 'publishing_hash' to table 'immotool_agency_exports_publishings'
-- Add field 'file_hash' to table 'openestate_objects_files'
-- Add field 'object_group_id' to table 'openestate_objects'
-- Update settings for property exports.
-- Rebuild view 'view_immotool_agency_exports'
-- Rebuild view 'view_immotool_agency_exports_logs'
-- Rebuild view 'view_immotool_agency_exports_publishings'
-- Rebuild view 'view_openestate_objects_files'
-- Rebuild view 'view_openestate_objects'
-- Rebuild procedure 'save_immotool_agency_exports'
-- Rebuild procedure 'save_immotool_agency_exports_logs'
-- Rebuild procedure 'save_immotool_agency_exports_publishings'
-- Rebuild procedure 'save_openestate_objects_files'
-- Rebuild procedure 'set_openestate_objects_files_content'
-- Rebuild procedure 'save_immotool_agency_objects'
-- Rebuild procedure 'save_openestate_objects'
-- Drop field 'log_success' from table 'immotool_agency_exports_logs'
-- Drop field 'log_incremental' from table 'immotool_agency_exports_logs'
-- Drop field 'object_group_nr' from table 'immotool_agency_objects'
-- Drop procedure 'remove_immotool_agency_exports_entries'
-- Drop procedure 'save_immotool_agency_exports_entries'
-- Drop view 'view_immotool_agency_exports_entries'
-- Drop table 'immotool_agency_exports_entries'
-- Call temporary procedure 'immotool_agency_update_permissions'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add field 'search_id' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN search_id BIGINT DEFAULT NULL NULL
  BEFORE export_name;

ALTER TABLE immotool_agency_exports
  ADD FOREIGN KEY (search_id)
  REFERENCES immotool_agency_searches(search_id)
  MATCH SIMPLE
  ON UPDATE CASCADE
  ON DELETE SET DEFAULT;


-- -----------------------------------------------------
-- Add field 'expose_id' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN expose_id BIGINT DEFAULT NULL NULL
  BEFORE export_name;

ALTER TABLE immotool_agency_exports
  ADD FOREIGN KEY (expose_id)
  REFERENCES immotool_agency_exposes(expose_id)
  MATCH SIMPLE
  ON UPDATE CASCADE
  ON DELETE SET DEFAULT;

UPDATE immotool_agency_exports AS exp
  SET (exp.expose_id) = (SELECT setting_value FROM immotool_agency_exports_settings WHERE setting_key IN ('website_php.expose.id', 'website_html.expose.id') AND export_id=exp.export_id);

DELETE FROM immotool_agency_exports_settings
  WHERE setting_key='website_php.expose.id';

DELETE FROM immotool_agency_exports_settings
  WHERE setting_key='website_html.expose.id';


-- -----------------------------------------------------
-- Add field 'export_notes' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN export_notes LONGVARCHAR DEFAULT NULL NULL
  BEFORE access_owner_id;


-- -----------------------------------------------------
-- Add field 'export_format' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN export_format VARCHAR(255) DEFAULT NULL NULL
  BEFORE export_limit;

UPDATE immotool_agency_exports AS exp
  SET (exp.export_format) = (SELECT setting_value FROM immotool_agency_exports_settings WHERE setting_key='format' AND export_id=exp.export_id);

UPDATE immotool_agency_exports
  SET export_format = 'openimmo'
  WHERE export_format IS NULL;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN export_format DROP DEFAULT;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN export_format SET NOT NULL;

DELETE FROM immotool_agency_exports_settings
  WHERE setting_key='format';


-- -----------------------------------------------------
-- Add field 'export_transport' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN export_transport VARCHAR(255) DEFAULT NULL NULL
  BEFORE export_limit;

UPDATE immotool_agency_exports AS exp
  SET (exp.export_transport) = (SELECT setting_value FROM immotool_agency_exports_settings WHERE setting_key='transport' AND export_id=exp.export_id);

UPDATE immotool_agency_exports
  SET export_transport = 'local'
  WHERE export_transport IS NULL;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN export_transport DROP DEFAULT;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN export_transport SET NOT NULL;

DELETE FROM immotool_agency_exports_settings
  WHERE setting_key='transport';


-- -----------------------------------------------------
-- Add field 'export_transfer' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN export_transfer VARCHAR(255) DEFAULT NULL NULL
  BEFORE export_limit;

UPDATE immotool_agency_exports AS exp
  SET (exp.export_transfer) = (SELECT setting_value FROM immotool_agency_exports_settings WHERE setting_key='format.incremental' AND setting_value='true' AND export_id=exp.export_id);

UPDATE immotool_agency_exports
  SET export_transfer = 'INCREMENTAL'
  WHERE export_transfer = 'true';

UPDATE immotool_agency_exports
  SET export_transfer = 'FULL'
  WHERE export_transfer = 'false';

UPDATE immotool_agency_exports
  SET export_transfer = 'FULL'
  WHERE export_transfer NOT IN ('INCREMENTAL', 'FULL') OR export_transfer IS NULL;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN export_transfer DROP DEFAULT;

ALTER TABLE immotool_agency_exports
  ALTER COLUMN export_transfer SET NOT NULL;

DELETE FROM immotool_agency_exports_settings
  WHERE setting_key='format.incremental';


-- -----------------------------------------------------
-- Add field 'export_lock_time' to table 'immotool_agency_exports'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports
  ADD COLUMN export_lock_time TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL
  BEFORE export_notes;


-- -----------------------------------------------------
-- Add field 'log_transfer' to table 'immotool_agency_exports_logs'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports_logs
  ADD COLUMN log_transfer VARCHAR(100) DEFAULT NULL NULL
  BEFORE log_limit;

UPDATE immotool_agency_exports_logs
  SET log_transfer = 'INCREMENTAL'
  WHERE log_incremental = TRUE;

UPDATE immotool_agency_exports_logs
  SET log_transfer = 'FULL'
  WHERE log_transfer IS NULL;

ALTER TABLE immotool_agency_exports_logs
  ALTER COLUMN log_transfer DROP DEFAULT;

ALTER TABLE immotool_agency_exports_logs
  ALTER COLUMN log_transfer SET NOT NULL;


-- -----------------------------------------------------
-- Add field 'log_count_inserts' to table 'immotool_agency_exports_logs'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports_logs
  ADD COLUMN log_count_inserts INT DEFAULT 0 NOT NULL
  BEFORE log_count_updates;


-- -----------------------------------------------------
-- Add field 'publishing_hash' to table 'immotool_agency_exports_publishings'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports_publishings
  ADD COLUMN publishing_hash VARCHAR(40) DEFAULT NULL NULL
  BEFORE publishing_time;


-- -----------------------------------------------------
-- Add field 'file_hash' to table 'openestate_objects_files'
-- -----------------------------------------------------
ALTER TABLE openestate_objects_files
  ADD COLUMN file_hash VARCHAR(40) DEFAULT NULL NULL
  BEFORE file_image_width;


-- -----------------------------------------------------
-- Add field 'object_group_id' to table 'openestate_objects'
-- -----------------------------------------------------
ALTER TABLE openestate_objects
  ADD COLUMN object_group_id VARCHAR(255) DEFAULT NULL NULL
  BEFORE object_currency;

UPDATE openestate_objects AS obj
  SET (obj.object_group_id) = (SELECT object_group_nr FROM immotool_agency_objects WHERE object_id=obj.object_id AND object_group_nr IS NOT NULL);


-- -----------------------------------------------------
-- Update settings for property exports.
-- -----------------------------------------------------
DELETE FROM immotool_agency_exports_settings
  WHERE setting_key = 'format.attachment.mode' AND setting_value = 'DISABLED';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.address.publication'
  WHERE setting_key = 'format.address.export';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.address.hideUnpublished'
  WHERE setting_key = 'format.address.hideUnpublished';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.file.publication'
  WHERE setting_key = 'format.attachment.export';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.prefix'
  WHERE setting_key = 'format.id.prefix';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.image.limit'
  WHERE setting_key = 'format.image.count';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.attachment.image.scale'
  WHERE setting_key = 'format.image.scale';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.attachment.image.scale.width'
  WHERE setting_key = 'format.image.scale.width';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.attachment.image.scale.height'
  WHERE setting_key = 'format.image.scale.height';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.image.watermark'
  WHERE setting_key = 'format.image.watermark';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.image.watermark.alpha'
  WHERE setting_key = 'format.image.watermark.alpha';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.image.watermark.position'
  WHERE setting_key = 'format.image.watermark.position';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.image.watermark.width'
  WHERE setting_key = 'format.image.watermark.width';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.image.watermark.height'
  WHERE setting_key = 'format.image.watermark.height';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.video.limit'
  WHERE setting_key = 'format.video.count';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.xml.linebreak'
  WHERE setting_key = 'format.linebreak';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.publicId'
  WHERE setting_key = 'format.daft_ie.usePublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.id'
  WHERE setting_key = 'format.idx.agentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.publicId'
  WHERE setting_key = 'format.idx.usePublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.id'
  WHERE setting_key = 'format.is24_csv.agentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.publicId'
  WHERE setting_key = 'format.is24_csv.usePublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.id'
  WHERE setting_key = 'format.is24_xml.agentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.publicId'
  WHERE setting_key = 'format.is24_xml.usePublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.mail'
  WHERE setting_key = 'format.is24_xml.technicsMail';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.id'
  WHERE setting_key = 'format.immoxml.agentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.mail'
  WHERE setting_key = 'format.immoxml.technicsMail';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.price.publication'
  WHERE setting_key = 'format.immoxml.pricesExport';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.immoxml.attachment.location'
  WHERE setting_key = 'format.immoxml.attachmentLocation';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.immoxml.agent.id'
  WHERE setting_key = 'format.immoxml.immoxmlAgentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.immoxml.property.publicId.exported'
  WHERE setting_key = 'format.immoxml.publishPublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.mail'
  WHERE setting_key = 'format.immobiliare.agentMail';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.publicId'
  WHERE setting_key = 'format.immobiliare.usePublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.immobiliare.publisher.mail'
  WHERE setting_key = 'format.immobiliare.publisherMail';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.id'
  WHERE setting_key = 'format.openimmo.agentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.mail'
  WHERE setting_key = 'format.openimmo.technicsMail';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.price.publication'
  WHERE setting_key = 'format.openimmo.pricesExport';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.openimmo.attachment.location'
  WHERE setting_key = 'format.openimmo.attachmentLocation';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.openimmo.agent.id'
  WHERE setting_key = 'format.openimmo.openimmoAgentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.openimmo.property.publicId.exported'
  WHERE setting_key = 'format.openimmo.publishPublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.agent.id'
  WHERE setting_key = 'format.wis_it.agentId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.property.publicId'
  WHERE setting_key = 'format.wis_it.usePublicId';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_html.show.agent'
  WHERE setting_key = 'format.website_html.expose.showAgent';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_html.show.contact'
  WHERE setting_key = 'format.website_html.expose.showContact';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_html.show.terms'
  WHERE setting_key = 'format.website_html.expose.showTerms';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_html.title'
  WHERE setting_key = 'format.website_html.pageTitle';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_php.show.contactForm'
  WHERE setting_key = 'format.website_php.expose.showContactForm';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_php.show.contactPerson'
  WHERE setting_key = 'format.website_php.expose.showContactPerson';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_php.show.terms'
  WHERE setting_key = 'format.website_php.expose.showTerms';

UPDATE immotool_agency_exports_settings
  SET setting_key = 'format.website_php.title'
  WHERE setting_key = 'format.website_php.pageTitle';


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_exports'
-- -----------------------------------------------------
ALTER VIEW view_immotool_agency_exports AS
  SELECT * FROM immotool_agency_exports
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_exports_logs'
-- -----------------------------------------------------
ALTER VIEW view_immotool_agency_exports_logs AS
  SELECT
    log_id,
    export_id,
    log_format,
    log_transport,
    log_transfer,
    log_limit,
    log_count_inserts,
    log_count_updates,
    log_count_deletes,
    log_count_errors,
    log_time
  FROM immotool_agency_exports_logs
    WHERE export_id IN (SELECT export_id FROM view_immotool_agency_exports);


-- -----------------------------------------------------
-- Rebuild view 'view_immotool_agency_exports_publishings'
-- -----------------------------------------------------
ALTER VIEW view_immotool_agency_exports_publishings AS
  SELECT * FROM immotool_agency_exports_publishings
  WHERE export_id IN (SELECT export_id FROM view_immotool_agency_exports);


-- -----------------------------------------------------
-- Rebuild view 'view_openestate_objects_files'
-- -----------------------------------------------------
ALTER VIEW view_openestate_objects_files AS
  SELECT
    file_id,
    object_id,
    file_name,
    file_url,
    file_mimetype,
    file_published,
    file_type,
    file_size,
    file_hash,
    file_image_width,
    file_image_height,
    file_position,
    created_at,
    modified_at
  FROM openestate_objects_files
  WHERE object_id IN (SELECT object_id FROM view_openestate_objects);


-- -----------------------------------------------------
-- Rebuild view 'view_openestate_objects'
-- -----------------------------------------------------
ALTER VIEW view_openestate_objects AS
  SELECT
    a.*,
    b.object_status,
    b.object_export_mode,
    b.object_import_id,
    b.object_import_hash,
    b.object_notes,
    b.access_owner_id,
    b.access_group_id,
    b.access_permissions
  FROM openestate_objects a
  INNER JOIN immotool_agency_objects b ON ( a.object_id = b.object_id )
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(b.access_permissions, 64) = 64)
    OR
    (BITAND(b.access_permissions, 8) = 8 AND b.access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(b.access_permissions, 1) = 1 AND b.access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_exports'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_immotool_agency_exports;

\.
CREATE PROCEDURE save_immotool_agency_exports(
    INOUT val_export_id BIGINT,
    val_search_id BIGINT,
    val_expose_id BIGINT,
    val_export_name VARCHAR(100),
    val_export_enabled BOOLEAN,
    val_export_format VARCHAR(255),
    val_export_transport VARCHAR(255),
    val_export_transfer VARCHAR(255),
    val_export_limit INT,
    val_export_last_execution TIMESTAMP WITH TIME ZONE,
    val_export_lock_time TIMESTAMP WITH TIME ZONE,
    val_export_notes LONGVARCHAR,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_agency_exports
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neuen Export erzeugen
    IF val_export_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Export speichern
      INSERT INTO immotool_agency_exports (
        search_id,
        expose_id,
        export_name,
        export_enabled,
        export_format,
        export_transport,
        export_transfer,
        export_limit,
        export_last_execution,
        export_lock_time,
        export_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_search_id,
        val_expose_id,
        val_export_name,
        val_export_enabled,
        val_export_format,
        val_export_transport,
        val_export_transfer,
        val_export_limit,
        val_export_last_execution,
        val_export_lock_time,
        val_export_notes,
        owner_uid,
        owner_gid,
        permissions );

      -- ID zurückliefern
      SET val_export_id = IDENTITY();

    -- Bestehenden Export bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_agency_exports
        WHERE export_id = val_export_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Export bearbeiten
      UPDATE immotool_agency_exports
        SET
          search_id = val_search_id,
          expose_id = val_expose_id,
          export_name = val_export_name,
          export_enabled = val_export_enabled,
          export_format = val_export_format,
          export_transport = val_export_transport,
          export_transfer = val_export_transfer,
          export_limit = val_export_limit,
          export_last_execution = val_export_last_execution,
          export_lock_time = val_export_lock_time,
          export_notes = val_export_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          export_id = val_export_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_exports
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_exports_logs'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_immotool_agency_exports_logs;

\.
CREATE PROCEDURE save_immotool_agency_exports_logs(
    INOUT val_log_id BIGINT,
    val_export_id BIGINT,
    val_log_format VARCHAR(100),
    val_log_transport VARCHAR(100),
    val_log_transfer VARCHAR(100),
    val_log_limit INT,
    val_log_count_inserts INT,
    val_log_count_updates INT,
    val_log_count_deletes INT,
    val_log_count_errors INT,
    val_log_time TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_immotool_agency_exports_logs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    IF NOT allowed = TRUE AND val_export_id IS NOT NULL AND val_export_id > 0 THEN
      SET allowed = can_write_immotool_agency_exports( val_export_id );
    END IF;
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neues Log
    IF val_log_id < 1 THEN

      -- Log speichern
      INSERT INTO immotool_agency_exports_logs (
        export_id,
        log_format,
        log_transport,
        log_transfer,
        log_limit,
        log_count_inserts,
        log_count_updates,
        log_count_deletes,
        log_count_errors,
        log_time )
      VALUES (
        val_export_id,
        val_log_format,
        val_log_transport,
        val_log_transfer,
        val_log_limit,
        val_log_count_inserts,
        val_log_count_updates,
        val_log_count_deletes,
        val_log_count_errors,
        val_log_time );

      -- ID zurückliefern
      SET val_log_id = IDENTITY();

    ELSE

      -- Log bearbeiten
      UPDATE immotool_agency_exports_logs
        SET
          export_id = val_export_id,
          log_format = val_log_format,
          log_transport = val_log_transport,
          log_transfer = val_log_transfer,
          log_limit = val_log_limit,
          log_count_inserts = val_log_count_inserts,
          log_count_updates = val_log_count_updates,
          log_count_deletes = val_log_count_deletes,
          log_count_errors = val_log_count_errors,
          log_time = val_log_time
        WHERE
          log_id = val_log_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_exports_logs
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_exports_publishings'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_immotool_agency_exports_publishings;

\.
CREATE PROCEDURE save_immotool_agency_exports_publishings(
    val_export_id BIGINT,
    val_publishing_object_id BIGINT,
    val_publishing_object_nr VARCHAR(255),
    val_publishing_object_key VARCHAR(255),
    val_publishing_hash VARCHAR(40),
    val_publishing_time TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_immotool_agency_exports_publishings
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    IF NOT allowed = TRUE AND val_export_id IS NOT NULL AND val_export_id > 0 THEN
      SET allowed = can_write_immotool_agency_exports( val_export_id );
    END IF;
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- ggf. existierenden Eintrag entfernen
    DELETE
      FROM immotool_agency_exports_publishings
      WHERE export_id = val_export_id
      AND publishing_object_id = val_publishing_object_id;

    -- Eintrag speichern
    INSERT INTO immotool_agency_exports_publishings (
      export_id,
      publishing_object_id,
      publishing_object_nr,
      publishing_object_key,
      publishing_hash,
      publishing_time )
    VALUES (
      val_export_id,
      val_publishing_object_id,
      val_publishing_object_nr,
      val_publishing_object_key,
      val_publishing_hash,
      val_publishing_time );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_exports_publishings
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_openestate_objects_files'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_openestate_objects_files;

\.
CREATE PROCEDURE save_openestate_objects_files(
    INOUT val_file_id BIGINT,
    val_object_id BIGINT,
    val_file_name VARCHAR(255),
    val_file_url VARCHAR(255),
    val_file_content BLOB(1G),
    val_file_content_preview BLOB(1M),
    val_file_mimetype VARCHAR(255),
    val_file_published BOOLEAN,
    val_file_type VARCHAR(100),
    val_file_size BIGINT,
    val_file_hash VARCHAR(40),
    val_file_image_width INT,
    val_file_image_height INT,
    val_file_position INT
  )
  SPECIFIC save_openestate_objects_files
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_objects(val_object_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neue Datei
    IF val_file_id < 1 THEN

      -- Datei speichern
      INSERT INTO openestate_objects_files (
        object_id,
        file_name,
        file_url,
        file_mimetype,
        file_published,
        file_type,
        file_size,
        file_hash,
        file_image_width,
        file_image_height,
        file_position )
      VALUES (
        val_object_id,
        val_file_name,
        val_file_url,
        val_file_mimetype,
        val_file_published,
        val_file_type,
        val_file_size,
        val_file_hash,
        val_file_image_width,
        val_file_image_height,
        val_file_position );

      -- ID zurückliefern
      SET val_file_id = IDENTITY();

    ELSE

      -- Datei bearbeiten
      UPDATE openestate_objects_files
        SET
          object_id = val_object_id,
          file_name = val_file_name,
          file_url = val_file_url,
          file_mimetype = val_file_mimetype,
          file_published = val_file_published,
          file_type = val_file_type,
          file_size = val_file_size,
          file_hash = val_file_hash,
          file_image_width = val_file_image_width,
          file_image_height = val_file_image_height,
          file_position = val_file_position,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

    -- Datei ggf. aktualisieren
    IF val_file_content IS NOT NULL THEN

      -- Datei bearbeiten
      UPDATE openestate_objects_files
        SET
          file_content = val_file_content,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

    -- Vorschau ggf. aktualisieren
    IF val_file_content_preview IS NOT NULL THEN

      -- Vorschau bearbeiten
      UPDATE openestate_objects_files
        SET
          file_content_preview = val_file_content_preview,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_openestate_objects_files
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'set_openestate_objects_files_content'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS set_openestate_objects_files_content;

\.
CREATE PROCEDURE set_openestate_objects_files_content(
    val_file_id BIGINT,
    val_file_size BIGINT,
    val_file_hash VARCHAR(40),
    val_file_content BLOB(1G),
    val_file_content_preview BLOB(1M)
  )
  SPECIFIC set_openestate_objects_files_content
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_object_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_file_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SELECT object_id
      INTO val_object_id
      FROM openestate_objects_files
      WHERE file_id = val_file_id;
    SET allowed = can_write_immotool_agency_objects(val_object_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Datei ggf. aktualisieren
    IF val_file_content IS NOT NULL THEN

      -- Datei bearbeiten
      UPDATE openestate_objects_files
        SET
          file_content = val_file_content,
          file_size = val_file_size,
          file_hash = val_file_hash,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

    -- Vorschau ggf. aktualisieren
    IF val_file_content_preview IS NOT NULL THEN

      -- Vorschau bearbeiten
      UPDATE openestate_objects_files
        SET
          file_content_preview = val_file_content_preview,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE set_openestate_objects_files_content
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_immotool_agency_objects'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_immotool_agency_objects;

\.
CREATE PROCEDURE save_immotool_agency_objects(
    val_object_id BIGINT,
    val_object_status VARCHAR(25),
    val_object_export_mode VARCHAR(25),
    val_object_import_id VARCHAR(255),
    val_object_import_hash VARCHAR(255),
    val_object_notes LONGVARCHAR,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_agency_objects
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_id BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Datensatz ermitteln
    SELECT object_id, access_permissions, access_owner_id, access_group_id
      INTO current_id, permissions, owner_uid, owner_gid
      FROM immotool_agency_objects
      WHERE object_id = val_object_id;

    -- Datensatz existiert noch nicht
    IF current_id IS NULL THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Immobilien-Zusatz einfügen
      INSERT INTO immotool_agency_objects (
        object_id,
        object_status,
        object_export_mode,
        object_import_id,
        object_import_hash,
        object_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_object_id,
        val_object_status,
        val_object_export_mode,
        val_object_import_id,
        val_object_import_hash,
        val_object_notes,
        owner_uid,
        owner_gid,
        permissions );

    -- Datensatz existiert bereits
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Immobilien-Zusatz aktualisieren
      UPDATE immotool_agency_objects
        SET
          object_status = val_object_status,
          object_export_mode = val_object_export_mode,
          object_import_id = val_object_import_id,
          object_import_hash = val_object_import_hash,
          object_notes = val_object_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions
        WHERE
          object_id = val_object_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_agency_objects
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild procedure 'save_openestate_objects'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS save_openestate_objects;

\.
CREATE PROCEDURE save_openestate_objects(
    INOUT val_object_id BIGINT,
    val_contact_id BIGINT,
    val_object_type VARCHAR(100),
    val_object_action VARCHAR(100),
    val_object_public_id VARCHAR(255),
    val_object_group_id VARCHAR(255),
    val_object_currency CHAR(3),
    val_object_hidden_prices BOOLEAN,
    val_object_publish_begin TIMESTAMP,
    val_object_publish_end TIMESTAMP,
    val_address_published BOOLEAN,
    val_address_street VARCHAR(150),
    val_address_street2 VARCHAR(150),
    val_address_street_nr VARCHAR(20),
    val_address_postal_code VARCHAR(10),
    val_address_city VARCHAR(150),
    val_address_district VARCHAR(150),
    val_address_country CHAR(2),
    val_address_region VARCHAR(150),
    val_address_latitude DECIMAL(15,12),
    val_address_longitude DECIMAL(15,12)
  )
  SPECIFIC save_openestate_objects
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Neues Objekt erzeugen
    IF val_object_id < 1 THEN

      -- Objekt speichern
      INSERT INTO openestate_objects (
        contact_id,
        object_type,
        object_action,
        object_public_id,
        object_group_id,
        object_currency,
        object_hidden_prices,
        object_publish_begin,
        object_publish_end,
        address_published,
        address_street,
        address_street2,
        address_street_nr,
        address_postal_code,
        address_city,
        address_district,
        address_country,
        address_region,
        address_latitude,
        address_longitude )
      VALUES (
        val_contact_id,
        val_object_type,
        val_object_action,
        val_object_public_id,
        val_object_group_id,
        val_object_currency,
        val_object_hidden_prices,
        val_object_publish_begin,
        val_object_publish_end,
        val_address_published,
        val_address_street,
        val_address_street2,
        val_address_street_nr,
        val_address_postal_code,
        val_address_city,
        val_address_district,
        val_address_country,
        val_address_region,
        val_address_latitude,
        val_address_longitude );

      -- ID zurückliefern
      SET val_object_id = IDENTITY();

    -- Bestehendes Objekt bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SET allowed = can_write_immotool_agency_objects(val_object_id);
      IF NOT allowed = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

      -- Objekt bearbeiten
      UPDATE openestate_objects
        SET
          contact_id = val_contact_id,
          object_type = val_object_type,
          object_action = val_object_action,
          object_public_id = val_object_public_id,
          object_group_id = val_object_group_id,
          object_currency = val_object_currency,
          object_hidden_prices = val_object_hidden_prices,
          object_publish_begin = val_object_publish_begin,
          object_publish_end = val_object_publish_end,
          address_published = val_address_published,
          address_street = val_address_street,
          address_street2 = val_address_street2,
          address_street_nr = val_address_street_nr,
          address_postal_code = val_address_postal_code,
          address_city = val_address_city,
          address_district = val_address_district,
          address_country = val_address_country,
          address_region = val_address_region,
          address_latitude = val_address_latitude,
          address_longitude = val_address_longitude,
          modified_at = NOW()
        WHERE
          object_id = val_object_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_openestate_objects
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Drop field 'log_success' from table 'immotool_agency_exports_logs'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports_logs
  DROP COLUMN log_success RESTRICT;


-- -----------------------------------------------------
-- Drop field 'log_incremental' from table 'immotool_agency_exports_logs'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_exports_logs
  DROP COLUMN log_incremental RESTRICT;


-- -----------------------------------------------------
-- Drop field 'object_group_nr' from table 'immotool_agency_objects'
-- -----------------------------------------------------
ALTER TABLE immotool_agency_objects
  DROP COLUMN object_group_nr RESTRICT;


-- -----------------------------------------------------
-- Drop procedure 'remove_immotool_agency_exports_entries'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS remove_immotool_agency_exports_entries CASCADE;


-- -----------------------------------------------------
-- Drop procedure 'save_immotool_agency_exports_entries'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_agency_exports_entries CASCADE;


-- -----------------------------------------------------
-- Drop view 'view_immotool_agency_exports_entries'
-- -----------------------------------------------------
DROP VIEW IF EXISTS view_immotool_agency_exports_entries CASCADE;


-- -----------------------------------------------------
-- Drop table 'immotool_agency_exports_entries'
-- -----------------------------------------------------
DROP TABLE IF EXISTS immotool_agency_exports_entries CASCADE;


-- -----------------------------------------------------
-- Call temporary procedure 'immotool_agency_update_permissions'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS immotool_agency_update_permissions;

\.
CREATE PROCEDURE immotool_agency_update_permissions()
  SPECIFIC immotool_agency_update_permissions
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE pluginId BIGINT;
    DECLARE permissionId BIGINT;
    DECLARE groupId BIGINT;

    -- ID des Plugins ermitteln
    SELECT plugin_id
      INTO pluginId
      FROM immotool_plugins
      WHERE plugin_name = 'OpenEstate-Tool-Agency';

    -- USE_PLUGIN-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'USE_PLUGIN' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ID der IMMOTOOL-Gruppe ermitteln
    SELECT group_id
      INTO groupId
      FROM immotool_groups
      WHERE group_name = 'IMMOTOOL';

    -- USE_PLUGIN-Berechtigung zur IMMOTOOL-Gruppe zuweisen
    INSERT INTO immotool_groups_permissions (
      group_id,
      permission_id )
    VALUES (
      groupId,
      permissionId );

    -- Umbenennung der bestehenden Berechtigungen
    UPDATE immotool_permissions
      SET permission_key = 'CONTACTS', modified_at = NOW()
      WHERE permission_key = 'contact.view'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'CONTACTS_EDIT', modified_at = NOW()
      WHERE permission_key = 'contact.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'CONTACTS_REMOVE', modified_at = NOW()
      WHERE permission_key = 'contact.remove'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'PROPERTIES', modified_at = NOW()
      WHERE permission_key = 'estate.view'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'PROPERTIES_EDIT', modified_at = NOW()
      WHERE permission_key = 'estate.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'PROPERTIES_EDIT_STATUS', modified_at = NOW()
      WHERE permission_key = 'estate.edit_status'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'PROPERTIES_REMOVE', modified_at = NOW()
      WHERE permission_key = 'estate.remove'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'PROPERTIES_IMPORT', modified_at = NOW()
      WHERE permission_key = 'estate.import'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'EXPORTS', modified_at = NOW()
      WHERE permission_key = 'export.view'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'EXPORTS_EDIT', modified_at = NOW()
      WHERE permission_key = 'export.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'EXPORTS_EXECUTE', modified_at = NOW()
      WHERE permission_key = 'export.execute'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'EXPORTS_REMOVE', modified_at = NOW()
      WHERE permission_key = 'export.remove'
      AND plugin_id = pluginId;


    -- PROPERTIES_EDIT_STATUS_PUBLISHING-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'PROPERTIES_EDIT_STATUS_PUBLISHING' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- PROPERTIES_EDIT_STATUS_PUBLISHING-Berechtigung allen Benutzern mit PROPERTIES_EDIT_STATUS-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='PROPERTIES_EDIT_STATUS')
      );

    -- PROPERTIES_EDIT_STATUS_PUBLISHING-Berechtigung allen Gruppen mit PROPERTIES_EDIT_STATUS-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='PROPERTIES_EDIT_STATUS')
      );


    -- PROPERTIES_EDIT_STATUS_UNPUBLISHING-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'PROPERTIES_EDIT_STATUS_UNPUBLISHING' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- PROPERTIES_EDIT_STATUS_UNPUBLISHING-Berechtigung allen Benutzern mit PROPERTIES_EDIT_STATUS-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='PROPERTIES_EDIT_STATUS')
      );

    -- PROPERTIES_EDIT_STATUS_UNPUBLISHING-Berechtigung allen Gruppen mit PROPERTIES_EDIT_STATUS-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='PROPERTIES_EDIT_STATUS')
      );

  END;
.;

CALL immotool_agency_update_permissions();

DROP PROCEDURE
  IF EXISTS immotool_agency_update_permissions;
