-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 14 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_TYPE' to 'ENERGY_CERTIFICATE.TYPE'
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_DEMAND' to 'ENERGY_CERTIFICATE.DEMAND_TOTAL'
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_CONSUMPTION' to 'ENERGY_CERTIFICATE.CONSUMPTION_TOTAL'
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_EXPIRATION' to 'ENERGY_CERTIFICATE.EXPIRATION_DATE'
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_INCLUDING_HOT_WATER' to 'ENERGY_CERTIFICATE.CONSUMPTION_INCLUDING_HOT_WATER'
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_THERMAL_HEAT_DEMAND' to 'ENERGY_CERTIFICATE.AUSTRIA_THERMAL_HEAT_DEMAND'
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_TOTAL_ENERGY_EFFICIENCY_FACTOR' to 'ENERGY_CERTIFICATE.AUSTRIA_TOTAL_ENERGY_EFFICIENCY_FACTOR'
-- Rename attribute 'ADMINISTRATION.ENERGY_CLASS' to 'ENERGY_CERTIFICATE.EFFICIENCY_CATEGORY'
-- Rename attribute 'ADMINISTRATION.ENERGY_CONSUMPTION' to 'ENERGY_CERTIFICATE.CONSUMPTION_TOTAL'
-- Rename attribute 'ADMINISTRATION.ENERGY_CONSUMPTION_CERTIFIED' to 'ENERGY_CERTIFICATE.AVAILABLE'
-- Rename attribute 'SURROUNDINGS.AREA' to 'SURROUNDINGS.ZONE'
-- Rename some options for attribute 'SURROUNDINGS.ZONE'
-- Rename attribute 'SURROUNDINGS.COMMERCIAL_AREA' to 'SURROUNDINGS.COMMERCIAL_ZONE'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_TYPE' to 'ENERGY_CERTIFICATE.TYPE'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_TYPE'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_TYPE';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_DEMAND' to 'ENERGY_CERTIFICATE.DEMAND_TOTAL'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_DEMAND_TOTAL'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_DEMAND';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_CONSUMPTION' to 'ENERGY_CERTIFICATE.CONSUMPTION_TOTAL'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_CONSUMPTION_TOTAL'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_CONSUMPTION';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_EXPIRATION' to 'ENERGY_CERTIFICATE.EXPIRATION_DATE'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_EXPIRATION_DATE'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_EXPIRATION';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_INCLUDING_HOT_WATER' to 'ENERGY_CERTIFICATE.CONSUMPTION_INCLUDING_HOT_WATER'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_CONSUMPTION_INCLUDING_HOT_WATER'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_INCLUDING_HOT_WATER';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_THERMAL_HEAT_DEMAND' to 'ENERGY_CERTIFICATE.AUSTRIA_THERMAL_HEAT_DEMAND'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_AUSTRIA_THERMAL_HEAT_DEMAND'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_THERMAL_HEAT_DEMAND';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CERTIFICATE_TOTAL_ENERGY_EFFICIENCY_FACTOR' to 'ENERGY_CERTIFICATE.AUSTRIA_TOTAL_ENERGY_EFFICIENCY_FACTOR'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_AUSTRIA_TOTAL_ENERGY_EFFICIENCY_FACTOR'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CERTIFICATE_TOTAL_ENERGY_EFFICIENCY_FACTOR';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CLASS' to 'ENERGY_CERTIFICATE.EFFICIENCY_CATEGORY'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_EFFICIENCY_CATEGORY'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CLASS';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CONSUMPTION' to 'ENERGY_CERTIFICATE.CONSUMPTION_TOTAL'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_CONSUMPTION_TOTAL'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CONSUMPTION'
  AND
    object_id NOT IN (SELECT object_id FROM openestate_objects_attribs WHERE attrib_name = 'ENERGY_CERTIFICATE_CONSUMPTION_TOTAL');

DELETE FROM openestate_objects_attribs
  WHERE attrib_name = 'ADMINISTRATION_ENERGY_CONSUMPTION';


-- -----------------------------------------------------
-- Rename attribute 'ADMINISTRATION.ENERGY_CONSUMPTION_CERTIFIED' to 'ENERGY_CERTIFICATE.AVAILABLE'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'ENERGY_CERTIFICATE_AVAILABLE'
  WHERE
    attrib_name = 'ADMINISTRATION_ENERGY_CONSUMPTION_CERTIFIED';


-- -----------------------------------------------------
-- Rename attribute 'SURROUNDINGS.AREA' to 'SURROUNDINGS.ZONE'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'SURROUNDINGS_ZONE'
  WHERE
    attrib_name = 'SURROUNDINGS_AREA';

-- -----------------------------------------------------
-- Rename some options for attribute 'SURROUNDINGS.ZONE'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    value_string = 'RESIDENTIAL'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'RESIDENTIAL_AREA';

UPDATE openestate_objects_attribs
  SET
    value_string = 'COMMERCIAL'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'COMMERCIAL_AREA';

UPDATE openestate_objects_attribs
  SET
    value_string = 'INDUSTRIAL'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'INDUSTRIAL_AREA';

UPDATE openestate_objects_attribs
  SET
    value_string = 'MIXED'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'MIXED_AREA';

UPDATE openestate_objects_attribs
  SET
    value_string = 'DEVELOPMENT'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'DEVELOPMENT_AREA';

UPDATE openestate_objects_attribs
  SET
    value_string = 'CITY_CENTER'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'CITY_CENTRE';

UPDATE openestate_objects_attribs
  SET
    value_string = 'VILLAGE_CENTER'
  WHERE
    attrib_name = 'SURROUNDINGS_ZONE'
  AND
    value_string = 'VILLAGE_CENTRE';

-- -----------------------------------------------------
-- Rename attribute 'SURROUNDINGS.COMMERCIAL_AREA' to 'SURROUNDINGS.COMMERCIAL_ZONE'
-- -----------------------------------------------------
UPDATE openestate_objects_attribs
  SET
    attrib_name = 'SURROUNDINGS_COMMERCIAL_ZONE'
  WHERE
    attrib_name = 'SURROUNDINGS_COMMERCIAL_AREA';
